<?php
namespace Help\Controller;
use Common\Controller\HomebaseController;
/**
 * 文章列表
*/
class ListController extends HomebaseController {

	//文章内页
	public function index() {
		$term=sp_get_help_term($_GET['id']);
		
		if(empty($term)){
		    header('HTTP/1.1 404 Not Found');
		    header('Status:404 Not Found');
		    if(sp_template_file_exists(MODULE_NAME."/404")){
		        $this->display(":404");
		    }
		    	
		    return ;
		}
		$crumbs = sp_get_crumbs($term);
		$this->assign("crumbs",$crumbs);

		$users_obj = M("Users");
		$users_data=$users_obj->field("id,user_login")->where("user_status=1")->select();
		$users=array();
		foreach ($users_data as $u){
			$users[$u['id']]=$u;
		}

		$this->assign("users",$users);
		$cat_id = intval($_GET['id']);
		if($term['taxonomy'] == 'default'){
			$posts = sp_sql_helps_bycatid($cat_id,"order:post_date DESC;");
			$lists['posts'] = $posts;
			$this->assign('lists', $lists);
		}else{
			$posts = sp_sql_helps_bycatid(2,'',array($term['filters']));
			$lists['posts'] = $posts;
			$this->assign('lists', $lists);
		}
		$tplname=$term["list_tpl"];
    	$tplname=sp_get_apphome_tpl($tplname, "list");
    	$this->assign('cat_id', $cat_id);
		$this->assign($term);
    	$this->display(":$tplname");
	}
	
	public function nav_index(){
		$navcatname="帮助分类";
		$datas=sp_get_help_terms("field:term_id,name");
		$navrule=array(
				"action"=>"List/index",
				"param"=>array(
						"id"=>"term_id"
				),
				"label"=>"name");
		exit(sp_get_nav4admin($navcatname,$datas,$navrule));
		
	}
	
}
