<?php

namespace Help\Controller;
use Common\Controller\AdminbaseController;
class AdminNoticeController extends AdminbaseController {
	protected $posts_model;
	
	function _initialize() {
		parent::_initialize();
		$this->posts_model = D("Help/HelpNotice");
	}
	function index(){
		$this->_lists();
		$this->display();
	}
	
	function add(){
		$this->assign("author","1");
		$this->display();
	}
	
	function add_post(){
		if (IS_POST) {
			$_POST['post']['post_date']=date("Y-m-d H:i:s",time());
			$_POST['post']['post_author']=get_current_admin_id();
			$article=I("post.post");
			$article['post_content']=htmlspecialchars_decode($article['post_content']);
			$result=$this->posts_model->add($article);
			if ($result) {
				$this->success("添加成功！");
			} else {
				$this->error("添加失败！");
			}
			 
		}
	}
	
	public function edit(){
		$id=  intval(I("get.id"));
		$post=$this->posts_model->where("id=$id")->find();
		$this->assign("post",$post);
		$this->display();
	}
	
	public function edit_post(){
		if (IS_POST) {
			$post_id=intval($_POST['post']['id']);
			unset($_POST['post']['post_author']);
			$article=I("post.post");
			$article['post_content']=htmlspecialchars_decode($article['post_content']);
			$result=$this->posts_model->save($article);
			if ($result!==false) {
				$this->success("保存成功！");
			} else {
				$this->error("保存失败！");
			}
		}
	}
	
	//排序
	public function listorders() {
		$status = parent::_listorders($this->posts_model);
		if ($status) {
			$this->success("排序更新成功！");
		} else {
			$this->error("排序更新失败！");
		}
	}

	function delete(){
		if(isset($_GET['id'])){
			$id = intval(I("get.id"));
			if ($this->posts_model->where("id=$id")->delete()) {
				$this->success("删除成功！");
			} else {
				$this->error("删除失败！");
			}
		}
		if(isset($_POST['ids'])){
			$ids=join(",",$_POST['ids']);
			if ($this->posts_model->where("id in ($ids)")->delete()) {
				$this->success("删除成功！");
			} else {
				$this->error("删除失败！");
			}
		}
	}
	
	function check(){
		if(isset($_POST['ids']) && $_GET["check"]){
			$data["post_status"]=1;
			
			$ids=join(",",$_POST['ids']);
			if ( $this->posts_model->where("id in ($ids)")->save($data)!==false) {
				$this->success("发布成功！");
			} else {
				$this->error("发布失败！");
			}
		}
		if(isset($_POST['ids']) && $_GET["uncheck"]){
			
			$data["post_status"]=0;
			$ids=join(",",$_POST['ids']);
			if ( $this->posts_model->where("id in ($ids)")->save($data)) {
				$this->success("下线成功！");
			} else {
				$this->error("下线失败！");
			}
		}
	}
	
	function top(){
		if(isset($_POST['ids']) && $_GET["top"]){
			$data["istop"]=1;
				
			$ids=join(",",$_POST['ids']);
			if ( $this->posts_model->where("id in ($ids)")->save($data)!==false) {
				$this->success("置顶成功！");
			} else {
				$this->error("置顶失败！");
			}
		}
		if(isset($_POST['ids']) && $_GET["untop"]){
				
			$data["istop"]=0;
			$ids=join(",",$_POST['ids']);
			if ( $this->posts_model->where("id in ($ids)")->save($data)) {
				$this->success("取消置顶成功！");
			} else {
				$this->error("取消置顶失败！");
			}
		}
	}

	private  function _lists($status=1){

		$where_ands=array("post_status"=>$status);

		$fields=array(
			'start_time'=> array("field"=>"post_date","operator"=>">"),
			'end_time'  => array("field"=>"post_date","operator"=>"<"),
			'keyword'  => array("field"=>"post_title","operator"=>"like"),
		);
		if(IS_POST){
			foreach ($fields as $param =>$val){
				if (isset($_POST[$param]) && !empty($_POST[$param])) {
					$operator=$val['operator'];
					$field   =$val['field'];
					$get=$_POST[$param];
					$_GET[$param]=$get;
					if($operator=="like"){
						$get="%$get%";
					}
					array_push($where_ands, "$field $operator '$get'");
				}
			}
		}else{
			foreach ($fields as $param =>$val){
				if (isset($_GET[$param]) && !empty($_GET[$param])) {
					$operator=$val['operator'];
					$field   =$val['field'];
					$get=$_GET[$param];
					if($operator=="like"){
						$get="%$get%";
					}
					array_push($where_ands, "$field $operator '$get'");
				}
			}
		}

		$where= join(" and ", $where_ands);


		$count=$this->posts_model
			->where($where)
			->count();

		$page = $this->page($count, 20);


		$posts=$this->posts_model
			->where($where)
			->limit($page->firstRow . ',' . $page->listRows)
			->order("listorder ASC,post_modified DESC")->select();
		$users_obj = M("Users");
		$users_data=$users_obj->field("id,user_login")->where("user_status=1")->select();
		$users=array();
		foreach ($users_data as $u){
			$users[$u['id']]=$u;
		}
		$this->assign("users",$users);
		$this->assign("Page", $page->show('Admin'));
		$this->assign("current_page",$page->GetCurrentPage());
		unset($_GET[C('VAR_URL_PARAMS')]);
		$this->assign("formget",$_GET);
		$this->assign("posts",$posts);
	}
}