const BaseCollector = require('./baseCollector');
const baseCurrencies = ["BIX","ETH","BTC","USDT"];
const machine = process.env['MACHINE'];
const biboxApi = require('./api');
const zlib = require('zlib');
const Strategy3MaxAmountMap = {
  USDT: 1000,
  BTC: 0.15,
  ETH: 1.5,
  BIX:600
}

class BiboxCollector extends BaseCollector{
  constructor(wantedSymbols){
    super("BIBOX",baseCurrencies,machine,wantedSymbols);
    this.api = new biboxApi('','');
  }
  _convertSymbolName(symbol){
    return symbol.replace("_","");
  }
  _fetchSymbols(callback){
    this.api.fetchSymbols((error,data)=>{
      if(error){
        console.error("fetch symbol error");
        console.error(error);
        this._fetchSymbols(callback);
      }else{
        const symbolDetails = data.result;
        const symbolMap = {};
        for(let detail of symbolDetails){
          symbolMap[detail.pair] = detail;
        }
        callback(null,symbolMap);
      }
    })
  }

  _runMonitorInterval(){
    return 5 *1000;
  }

  _subscribeSymbols(symbols,callback,subscribeDepth){
    this.api.subscribeSymbols(symbols,(error,data)=>{
       if(error){
         console.error("subscribe error");
         console.error(error);
       }else{
         const symbol = data.channel.replace("bibox_sub_spot_","").replace("_depth","").replace("_","");
         const decodeStr = Buffer.from(data.data,'base64');
         const unzipData = zlib.unzipSync(decodeStr);
         const result = JSON.parse(unzipData.toString());
         // const symbol = result.pair.replace("_","");
         const timeStamp = result.update_time;
         const asks = result.asks.slice(0,subscribeDepth).map((item)=>[item.price,item.volume]);
         const bids = result.bids.slice(0,subscribeDepth).map((item)=>[item.price,item.volume]);
         callback(asks, bids, symbol, timeStamp);
       }
    })
  }
  _runMonitor(callback){
    this.api.balance((error,result)=>{
      if(error){
        console.error("get balance error");
        console.error(error);
        callback(null);
      }else{
        const balanceList = result.result.assets_list;
        const balanceMap = {};
        for(let detail of balanceList){
          if(detail.balance >0 || detail.freeze >0 || balanceMap[detail.coin_symbol]){
            balanceMap[detail.coin_symbol] = {available:detail.balance,onOrder:detail.freeze};
          }
        }
        callback(balanceMap);
      }
    })
  }

  getSymbol(fromCurrency,toCurrency){
    let symbolDetail = this._getSymbolDetail(fromCurrency,toCurrency);
    return symbolDetail.pair;
  }
  getFeeRate(fromCurrency,toCurrency){
    return 0.0005;
  }
  processAmount(fromCurrency,toCurrency,amount){
    //有可能会由于数值过小，传进来的amount被表示为科学计数法法
    const amountStr = parseFloat(amount).toFixed(10);
    const nums = amountStr.split('.');
    if(nums.length ===2 && nums[1].length>4){
      return nums[0]+"."+nums[1].slice(0,4);
    }
    return amount;
  }
  processPrice(fromCurrency,toCurrency,price){
    // const amountStr = price+'';
    // const nums = amountStr.split('.');
    // if(nums.length ===2 && nums[1].length>4){
    //   return nums[0]+"."+nums[1].slice(0,4);
    // }
    return price;
  }
  getCurrencyMaxReturnAmount(currency){
    const balance = this.getCurrencyBalance(currency);
    return Math.min(Strategy3MaxAmountMap[currency],balance);
  }
  getDepthPrintStr(fromCurrency,toCurrency,depth=1){
    return super.getDepthPrintStr(fromCurrency,toCurrency,3);
  }

}

module.exports = BiboxCollector;

