const RecordService = require('./recordService');


class Strategy3 {
  constructor(collector, machine) {
    this.collector = collector;
    this.service = new RecordService(null,null,collector.platformName);
    this.lastFuckTime = 0;
    this.machine = machine;
  }

  run() {
    this.collector.onSymbolUpdate = this.handleSymbolUpdate.bind(this);
  }

  handleSymbolUpdate(symbol, source) {
    if (symbol) {
      const midCurrency = this.collector.getMidCurrency(symbol);
      const symbols = this.collector.getSymbols(midCurrency);
      for (const currentSymbol of symbols) {
        if (currentSymbol != symbol && Date.now() - this.lastFuckTime > this._getMinTradeInterval()) {
          if (this.handleSymbolPairs(currentSymbol, symbol, source)) {
            this.lastFuckTime = Date.now();
          }
        }
      }
    }
  }

  handleSymbolPairs(symbol1, symbol2, source) {
    const startTime = Date.now();
    const result = this.calculateSymbolsMargin(symbol1, symbol2, source);
    const endTime = Date.now();
    if (result != -1) {
      console.log('计算开始：' + startTime + ' 计算结束：' + endTime);
      const buyDepth = this.collector.getDepthPrintStr(result[0], result[1]);
      const sellDepth = this.collector.getDepthPrintStr(result[1], result[2]);
      const returnDepth = this.collector.getDepthPrintStr(result[2], result[0]);
      const lastBuyDepth = this.collector.getLastDepthPrintStr(result[0],result[1]);
      const lastSellDepth = this.collector.getLastDepthPrintStr(result[1], result[2]);
      const buyRemark = `<p>通量${result[7]}<br/>now:${buyDepth.toString()}<br/>last:${lastBuyDepth}</p>`;
      const sellRemark = `<p>通量${result[7]}<br/>now:${sellDepth}<br/>last:${lastSellDepth}</p>`;
      const returnRemark = `<p>通量${result[8]}<br/>${returnDepth.toString()}</p>`;
      const baseCurrency1 = result[0];
      const midCurrency = result[1];
      const baseCurrency2 = result[2];
      const buyPrice = result[9];
      const sellPrice = result[10];
      const returnPrice = result[11];
      let amount = result[7];
      let returnAmount = result[8];
      // console.log({buyRemark, sellRemark, returnRemark});
      const sellSymbol = this.collector.getSymbol(midCurrency, baseCurrency2);
      const sellDelay = endTime - this.collector.getSymbolEventTime(sellSymbol);
      if(this._logDelay()){
        const buySymbol = this.collector.getSymbol(baseCurrency1, midCurrency);
        const buyDelay = endTime - this.collector.getSymbolEventTime(buySymbol);
        console.log('买入交易对延迟：' + buyDelay + " 卖出交易对延迟：" + sellDelay);
      }
      if(sellDelay > 5000){
          console.log('延时过大，放弃该轮交易');
          return false;
      }
      const service = this.service;
      let savedRecord = null;
      const finishedOrders = [];
      const that = this;
      function tryToSaveOrder(order, fromCurrency = null, toCurrency = null, operationType = null) {
        if (fromCurrency)
          order.fromCurrency = fromCurrency;
        if (toCurrency)
          order.toCurrency = toCurrency;
        if (operationType)
          order.operationType = operationType;
        if (savedRecord) {
          order.relatedRecordId = savedRecord.id;
          order.source = that.machine;
          if(source){
            order.source = order.source + `(${source})`;
          }
          that._getTrades(order, (samePriceTrade) => {
            if (!order.remark) {
              order.remark = '';
            }
            if (!samePriceTrade.length) {
              order.remark = order.remark + ",订单落地:" + order.transactTime;
              service.saveOrder(order);
            } else {
              samePriceTrade = samePriceTrade.reverse();
              order.remark = order.remark + "," + samePriceTrade.toString() + " 订单落地:" + order.transactTime;
              service.saveOrder(order);
            }
          })
        } else {
          finishedOrders.push(order);
        }
      }

      this._doTrade(baseCurrency1, midCurrency, baseCurrency2, buyPrice, sellPrice, returnPrice, amount, returnAmount, tryToSaveOrder);

      //保存利差记录
      service.saveRecord({
        buyPrice: result[4], sellPrice: result[5], returnPrice: result[6], buyRemark, sellRemark, returnRemark,
        buyFromCurrency: baseCurrency1, buyToCurrency: midCurrency, sellToCurrency: baseCurrency2
      }, (err, res) => {
        if (err) {
          console.error(err);
        } else {
          savedRecord = res.data;
          for (const order of finishedOrders) {
            tryToSaveOrder(order);
          }
        }
      });
      return true;
    }
    return false;
  }

  _doTrade(baseCurrency1, midCurrency, baseCurrency2, buyPrice, sellPrice, returnPrice, amount, returnAmount, doSaveOrder) {
    throw "覆盖此方法，完成交易";
  }

  /**
   * @param callback function(samePriceOrder),samePriceOrder是数组，每个元素是一个订单的json，每个订单需要time,price,amount
   */
  _getTrades(order,callback) {
    throw "覆盖方法_getTrades(symbol,filterDate,callback)，获取当前时间前后1秒的同价订单"
  }

  _logDelay(){
    return false;
  }

  /**
   * 手续费扣除是否通过平台币等币种另外扣除
   * 默认是true
   * @returns {boolean}
   */
  _isFeeDeducedByOther(){
    return true;
  }

  /**
   *
   * @returns {number} 百分比
   */
  _getMinMargin(){
    return 0.07;
  }

  _getMinReturnAmount(currency){
    throw '返回最小回归利差量';
  }
  _getMinTradeInterval(){
    return 1000 *5;
  }

  /**
   * 可覆盖此方法，添加额外的放弃订单的规则，默认采取相对保守的措施
   * 如果子类仍需要默认的保守措施，记得调用super方法
   */
  _giveUpOrder(baseCurrency1, midCurrency, baseCurrency2,totalMarginRate,buyDepth,sellDepth){
    const buyAmount = this._getTotalAmount(baseCurrency1, midCurrency, buyDepth)[0];
    const sellAmount = this._getTotalAmount(midCurrency, baseCurrency2, sellDepth)[0];
    if (parseFloat(buyAmount) > parseFloat(sellAmount)) {
      return true;
    }

    const buyLastDepth = this.collector.getLastDepth(baseCurrency1, midCurrency);
    const buyNowDepth = this.collector.getDepth(baseCurrency1, midCurrency);
    const sellLastDepth = this.collector.getLastDepth(midCurrency, baseCurrency2);
    const sellNowDepth = this.collector.getDepth(midCurrency, baseCurrency2);
    if (buyLastDepth && buyNowDepth && sellLastDepth && sellNowDepth) {
      if ((parseFloat(buyLastDepth[0][0]) - parseFloat(buyNowDepth[0][0])) / parseFloat(buyNowDepth[0][0]) < (parseFloat(sellNowDepth[0][0]) - parseFloat(sellLastDepth[0][0])) / parseFloat(sellLastDepth[0][0])) {
        return true;
      }
    }
    return false;
  }

  _adjustPrice(buyRawPrice,sellRawPrice,returnRawPrice,returnSide,totalMargin){
    return [buyRawPrice,sellRawPrice,returnRawPrice];
  }

  /**
   * 计算利差时，买，卖和回归分别看几个深度,默认都只看一个深度
   */
  _needConsiderDepthCount(){
    return [[1],[1],[1]];
  }
  calculateSymbolsMargin(symbol1, symbol2, source) {
    //判断是不是同一个交易对
    if (symbol1 == symbol2) {
      return -1;
    }
    //判断是同一个山寨币
    const midCurrency1 = this.collector.getMidCurrency(symbol1);
    const midCurrency2 = this.collector.getMidCurrency(symbol2);
    if (midCurrency1 != midCurrency2)
      return -1;
    //判断是否用了基础币来作为中间币
    // if (this.collector.isBaseCurrency(midCurrency1))
      // return -1;
    //获取基础币交易对
    const baseCurrency1 = this.collector.getBaseCurrency(symbol1);
    const baseCurrency2 = this.collector.getBaseCurrency(symbol2);
    // let result = this.calculateRouteMargin(baseCurrency1, midCurrency1, baseCurrency2, source);
    // if (result === -1){
     let result = this.calculateRouteMargin(baseCurrency2, midCurrency1, baseCurrency1, source);
     if(result === -1){
       result = this.calculateRouteMargin(baseCurrency1,midCurrency1,baseCurrency2,source);
     }
    // }
    return result;
  }

  calculateRouteMargin(baseCurrency1, midCurrency, baseCurrency2, source) {

    const best5SellDepth = this.collector.getDepth(midCurrency,baseCurrency2,5);
    if(best5SellDepth.length <5){
      // console.error(`${midCurrency}${baseCurrency2}深度不足5个，放弃此轮`);
      return -1;
    }

    const depthCount = this._needConsiderDepthCount();
    const buyDepthCount = depthCount[0];
    const sellDepthCount = depthCount[1];
    const returnDepthCount = depthCount[2];

    let finalResult = -1;
    for(let i=0;i<buyDepthCount.length;i++){
      for(let j=0;j<sellDepthCount.length;j++){
        for(let k=0;k<returnDepthCount.length;k++){
          const buyDepth = buyDepthCount[i];
          const sellDepth = sellDepthCount[j];
          const returnDepth = returnDepthCount[k];
          const result = this.calculateBestSolution(baseCurrency1, midCurrency, baseCurrency2,buyDepth,sellDepth,returnDepth);
          const amount = result[0];
          const returnAmount = result[1];
          const totalMarginRate = result[2];
          const buyPrice = result[3];
          const sellPrice = result[4];
          const returnPrice = result[5];
          const rawBuyPrice = result[6];
          const rawSellPrice = result[7];
          const rawReturnPrice = result[8];
          const buyFirst = result[9];
          if (totalMarginRate > this._getMinMargin()) {
            console.log(`发现利差：${totalMarginRate},buyDepth:${buyDepth},sellDepth${sellDepth},returnDepth${returnDepth}`);
            return [baseCurrency1, midCurrency, baseCurrency2, totalMarginRate, buyPrice, sellPrice, returnPrice, amount, returnAmount, rawBuyPrice, rawSellPrice, rawReturnPrice, buyFirst];
          }
        }
      }
    }
    return finalResult;
  }

  _getTotalAmount(fromCurrency,toCurrency,depth){
    let amount =0;
    let currency;
    for(let i=1;i<=depth;i++){
      const result = this.collector.getAmount(fromCurrency,toCurrency,i);
      amount += parseFloat(result[0]);
      currency = result[1];
    }
    return [amount,currency];
  }

  /**
   * 用于控制是否把当前允许的最大的通量全吃掉
   * @returns {number}
   */
  _getAmountRatio(baseCurrency1,midCurrency,baseCurrency2){
    return 1;
  }

  calculateBestSolution(baseCurrency1, midCurrency, baseCurrency2,buyDepth=1,sellDepth=1,returnDepth=1) {
    let bestProfit = -1;
    let bestAmount = 0;
    let bestReturnAmount = 0;
    let bestTotalMarginRate = 0;
    const buyFeeRate = this.collector.getFeeRate(baseCurrency1, midCurrency);
    const sellFeeRate = this.collector.getFeeRate(midCurrency, baseCurrency2);
    const returnFeeRate = this.collector.getFeeRate(baseCurrency2, baseCurrency1);

    let bestBuyPrice = 0;
    let bestSellPrice = 0;
    let bestReturnPrice = 0;
    let bestRawBuyPrice = 0;
    let bestRawSellPrice = 0;
    let bestRawReturnPrice = 0;
    const buyPrice = 1.0 / this.collector.getPrice(baseCurrency1, midCurrency, buyDepth);
    const sellPrice = this.collector.getPrice(midCurrency, baseCurrency2, sellDepth);
    const returnPrice = 1.0 / this.collector.getPrice(baseCurrency2, baseCurrency1, returnDepth);
    if (buyPrice < 0 || sellPrice < 0 || returnPrice < 0)
      return [0, 0, -2, 0, 0, 0, 0, 0, 0];

    // const buyAmount = this.collector.getAmount(baseCurrency1, midCurrency, buyDepth)[0];
    const buyAmount = this._getTotalAmount(baseCurrency1,midCurrency,buyDepth)[0];
    // const sellAmount = this.collector.getAmount(midCurrency, baseCurrency2, sellDepth)[0];
    const sellAmount = this._getTotalAmount(midCurrency,baseCurrency2,sellDepth)[0];
    const returnResult = this._getTotalAmount(baseCurrency2, baseCurrency1, returnDepth);
    const returnAmount = Math.min(returnResult[0], this.collector.getCurrencyMaxReturnAmount(returnResult[1]));
    const returnAmountCurrency = returnResult[1];
    let calculatedByReturnAmount = (returnAmountCurrency === baseCurrency2 ? (returnAmount / sellPrice) : (returnAmount / buyPrice));
    if(!this._isFeeDeducedByOther()){
      //手续费不是由平台币抵扣的情况回归通量计算要考虑手续费
      calculatedByReturnAmount = returnAmountCurrency === baseCurrency2 ? (returnAmount / (sellPrice*(1-sellFeeRate))) : (returnAmount / (buyPrice*(1+buyFeeRate)));
    }
    let amount = Math.min(buyAmount, sellAmount, calculatedByReturnAmount) * this._getAmountRatio(baseCurrency1,midCurrency,baseCurrency2);

    const m1 = 1.0 / (buyPrice * (1.0 + buyFeeRate));
    const m2 = m1 * sellPrice * (1.0 - sellFeeRate);
    const m3 = m2 / returnPrice * (1.0 - returnFeeRate);
    const totalMarginRate = (m3 - 1.0) * 100.0;

    if (totalMarginRate > 0) {
      const buyAmount = this.collector.processAmount(midCurrency, baseCurrency1, amount);
      const sellAmount = this.collector.processAmount(midCurrency, baseCurrency2, amount);
      amount = buyAmount.length > sellAmount.length ? sellAmount : buyAmount;
      const profit = totalMarginRate * amount;
      let return_amount = 0;
      if(this._isFeeDeducedByOther()){
         return_amount = returnAmountCurrency === baseCurrency2 ? amount * sellPrice : amount * buyPrice;
      }else{
        return_amount = returnAmountCurrency === baseCurrency2 ? amount * sellPrice * (1-sellFeeRate)  : amount * buyPrice * (1+sellFeeRate);
      }
      return_amount = this.collector.processAmount(baseCurrency2, baseCurrency1, return_amount);
      if (profit > 0 && profit > bestProfit && return_amount > this._getMinReturnAmount(returnAmountCurrency)) {
        if(this._giveUpOrder(baseCurrency1,midCurrency,baseCurrency2,totalMarginRate,buyDepth,sellDepth, returnAmount, returnAmountCurrency)){
          return [0, 0, -3, 0, 0, 0, 0, 0, 0];
        }
        bestReturnAmount = return_amount;
        bestProfit = profit;
        bestAmount = amount;
        bestTotalMarginRate = totalMarginRate;
        // bestBuyPrice = this.collector.processPrice(baseCurrency1, midCurrency, buyPrice);
        // bestSellPrice = this.collector.processPrice(midCurrency, baseCurrency2, sellPrice);
        // bestReturnPrice = this.collector.processPrice(baseCurrency2, baseCurrency1, returnPrice);
        bestBuyPrice = buyPrice;
        bestSellPrice = sellPrice;
        bestReturnPrice = returnPrice;
        bestRawBuyPrice = this.collector.getPrice(baseCurrency1, midCurrency, buyDepth, true);
        bestRawSellPrice = this.collector.getPrice(midCurrency, baseCurrency2, sellDepth, true);
        bestRawReturnPrice = this.collector.getPrice(baseCurrency2, baseCurrency1, returnDepth, true);
        const result = this._adjustPrice(bestRawBuyPrice,bestRawSellPrice,bestRawReturnPrice,
            this.collector.getTradeSide(baseCurrency2,baseCurrency1),bestTotalMarginRate);
        bestRawBuyPrice = result[0];
        bestRawSellPrice = result[1];
        bestRawReturnPrice = result[2];
        bestRawBuyPrice = this.collector.processPrice(baseCurrency1, midCurrency, bestRawBuyPrice);
        bestRawSellPrice = this.collector.processPrice(midCurrency, baseCurrency2, bestRawSellPrice);
        bestRawReturnPrice = this.collector.processPrice(baseCurrency2, baseCurrency1, bestRawReturnPrice);
      }
    } else if (totalMarginRate < 0) {
      return [0, 0, totalMarginRate, 0, 0, 0, 0, 0, 0];
    }
    return [bestAmount, bestReturnAmount, bestTotalMarginRate, bestBuyPrice, bestSellPrice, bestReturnPrice, bestRawBuyPrice, bestRawSellPrice, bestRawReturnPrice]
  }
}

module.exports = Strategy3;