const constants = require('./constants');
const biboxApi = require('./api_kucoin');

const StateFilled = 3;
const StateNew = 1;
const StatePartiallyFilled = 2;
const StatePartiallyCancelled = 4;
const StateCancelled = 5;
const StateCancelling = 6;

function returnFakeOrder(symbol, price, amount) {
  return {
    orderId: "testOrder",
    price: price,
    status: constants.OrderStatusCanceled,
    transactTime: Date.now(),
    origQty: amount,
    executedQty: 0,
    symbol: symbol,
  }
}

function convertToRecordOrder(order) {
  let status = constants.OrderStatusNew;
  if(!order.isActive){
    status = constants.OrderStatusCanceled;
  }else{
    if(order.pendingAmount === 0){
      status = constants.OrderStatusFilled;
    }
    // if(order.dealAmount === 0){
    //   status = constants.OrderStatusNew;
    // }
    if(order.dealAmount > 0 && order.pendingAmount >0){
      status = constants.OrderStatusPartiallyFilled;
    }
  }
  return {
    orderId: order.orderOid + '',
    price: order.dealPriceAverage,
    status: status,
    transactTime: order.createdAt,
    origQty: order.pendingAmount + order.dealAmount,
    executedQty: order.dealAmount,
    symbol: order.coinType + '-' + order.coinTypePair,
    type: order.type,
  }
}

function isTimeOutError(error){
  return error.code === 'ESOCKETTIMEDOUT' || error.code === 'ETIMEDOUT';
}

class Order {
  constructor() {
    this.api = new biboxApi();
  }

  _handleFOKSearchResult(orderId, symbol, side, finalCallback, error, result) {
    if (error) {
      console.error("搜索订单出错");
      console.error(error);
      let timeout = 100;
      if(error.code == '2091' || error.code == '4003'){
        console.log("2秒后再继续搜索");
        timeout = 2000;
      }
      setTimeout(() => {
        this.api.searchOrder(orderId, symbol, side, this._handleFOKSearchResult.bind(this, orderId, symbol, side, finalCallback));
      }, timeout);
      return;
    }
    const order = result.data || {};
    if(!order.dealAmount & !order.pendingAmount){
      console.error("没有返回amount 和deal amount字段，继续搜索");
      this.api.searchOrder(orderId, symbol, side, this._handleFOKSearchResult.bind(this, orderId, symbol, side, finalCallback));
    }else if (order.pendingAmount === 0 || !order.isActive) {
      finalCallback(null, convertToRecordOrder(order));
    } else if (order.dealAmount === 0 || (order.dealAmount > 0 && order.pendingAmount >0)) {
      this.api.cancelOrder(orderId, symbol, side, (error, result) => {
        // setTimeout(() => {
        console.log("尝试取消，准备搜索订单");
          this.api.searchOrder(orderId, symbol, side, this._handleFOKSearchResult.bind(this, orderId, symbol, side, finalCallback));
        // }, 80)
      })
    } else {
      setTimeout(() => {
      console.log("订单尚未完成或取消，再次搜索");
        this.api.searchOrder(orderId, symbol, side, this._handleFOKSearchResult.bind(this, orderId, symbol, side, finalCallback));
      }, 500);
    }
  }

  FOKLikeOrder(symbol, price, amount, side, callback) {
    if (!constants.RealOrder) {
      callback(null, returnFakeOrder(symbol, price, amount));
      return;
    }
    this.api.order(price, amount, symbol, side, (error, result) => {
      if (error) {
        callback(error, null);
        return;
      }
      const orderId = result.result;
      setTimeout(()=>{
        this.api.searchOrder(orderId, symbol, side, this._handleFOKSearchResult.bind(this, orderId, symbol, side, callback));
      },50);
    })
  }

  order(symbol, price, amount, side, callback,mustSuccess = false) {
    if (!constants.RealOrder) {
      callback(null, returnFakeOrder(symbol, price, amount));
      return;
    }
    this.api.order(price, amount, symbol, side, (error, result) => {
      if (error) {
        callback(error, null);
        return;
      }
      const orderId = result.data.orderOid;
      const api2 = this.api;

      function handleSearchResult(error, result) {
        if (error) {
          console.error("搜索订单出错");
          console.error(error);
          let timeout = 100;
          if(error.code == '2091' || error.code == '4003'){
            console.log("2秒后再继续搜索");
            timeout = 2000;
          }
          setTimeout(() => {
            this.api.searchOrder(orderId, this.handleSearchResult.bind(this, orderId, symbol, side, callback));
          }, timeout);
        }
        if(!result.data){
          console.error("没有返回amount，再次搜索");
          api2.searchOrder(orderId, symbol, side, handleSearchResult.bind(this));
          return;
        }
        callback(null, convertToRecordOrder(result.data));
      }

      this.api.searchOrder(orderId, symbol, side, handleSearchResult.bind(this));
    })
  }
}

module.exports = Order;