const BaseCollector = require('./baseCollector');
const baseCurrencies = ["ETH","BTC","USDT", "NEO", "KCS"];
const restCurrencies = ["PRA","AAC","AT","RED","BU","QTUM","EOSDAC","HPB","ORME","TRX","TTC", "USDT","BTC","ETH", "NEO", "KCS", ];
const machine = process.env['MACHINE'];
const biboxApi = require('./api_kucoin');
const IPReader = require('./util');
const IPs = IPReader.allIps;
let coinInfoMap = null;
const totalOrderbook = {};
const Strategy3MaxAmountMap = {
  USDT: 300,
  BTC: 0.05,
  ETH: 1.5,
  NEO: 30,
  KCS: 600,
}

function mergeDepthAsk(oldDepth, updateDepth) {
  const results = [];
  const cal = {old: 0, updated: 0};
  for (; cal.old < oldDepth.length || cal.updated < updateDepth.length;) {
    // if(results.length === length){
    //   break;
    // }
    if (oldDepth[cal.old] === undefined) {
      updateDepth[cal.updated][1] > 1e-8 && results.push(updateDepth[cal.updated]);
      cal.updated++;
    } else if (updateDepth[cal.updated] === undefined) {
      results.push(oldDepth[cal.old]);
      cal.old++;
    } else if (parseFloat(oldDepth[cal.old][0]) > parseFloat(updateDepth[cal.updated][0])) {
      updateDepth[cal.updated][1] > 1e-8 && results.push(updateDepth[cal.updated]);
      cal.updated++;
    } else if (parseFloat(oldDepth[cal.old][0]) === parseFloat(updateDepth[cal.updated][0])) {
      if (parseFloat(updateDepth[cal.updated][1]) > 1e-8) {
        results.push(updateDepth[cal.updated]);
      }
      cal.updated++;
      cal.old++;
    } else {
      results.push(oldDepth[cal.old]);
      cal.old++;
    }
  }
  return results

}
function mergeDepthBid(oldDepth, updateDepth) {
  const result = [];
  const cal = {old: 0, updated: 0};
  for (; cal.old < oldDepth.length || cal.updated < updateDepth.length;) {
    // if(result.length === length){
    //   break;
    // }
    if (oldDepth[cal.old] === undefined) {
      updateDepth[cal.updated][1] > 1e-8 && result.push(updateDepth[cal.updated]);
      cal.updated++;
    } else if (updateDepth[cal.updated] === undefined) {
      result.push(oldDepth[cal.old]);
      cal.old++;
    } else if (parseFloat(oldDepth[cal.old][0]) < parseFloat(updateDepth[cal.updated][0])) {
      updateDepth[cal.updated][1] > 1e-8 && result.push(updateDepth[cal.updated]);
      cal.updated++;
    } else if (parseFloat(oldDepth[cal.old][0]) === parseFloat(updateDepth[cal.updated][0])) {
      if (parseFloat(updateDepth[cal.updated][1]) > 1e-8) {
        result.push(updateDepth[cal.updated++]);
        cal.old++;
      } else {
        cal.updated++;
        cal.old++;
      }
    } else {
      result.push(oldDepth[cal.old++])
    }
  }
  return result;
}


class BiboxCollector extends BaseCollector{
  constructor(wantedSymbols){
    super("KUCOIN",baseCurrencies,machine,wantedSymbols);
    this.api = new biboxApi('','');
  }
  _convertSymbolName(symbol){
    return symbol.replace("-","").toUpperCase();
  }
  _fetchSymbols(callback){
    this.api.fetchSymbols((error,data)=>{
      if(error){
        console.error("fetch symbol error");
        console.error(error);
        this._fetchSymbols(callback);
      }else{
        const symbolDetails = data.data;
        const symbolMap = {};
        for(let detail of symbolDetails){
          symbolMap[detail.symbol] = detail;
        }
        callback(null,symbolMap);
      }
    })
  }

  _runMonitorInterval(){
    return 10 *1000;
  }

  _requestSymbolFullOrderbook(index,symbols,depth,baseCollectorCallback){
    if(index < symbols.length){
      this._doSubscribeSymbols(symbols,baseCollectorCallback,depth);
    }else{
      const symbol = symbols[index];
      const ipAddress = IPs[index%IPs.length];

      this.api.getOrderbook(symbol,depth,ipAddress,(error,result)=>{
        if(error){
          console.error("get depth by rest error:");
          console.error(error);
          this._requestSymbolFullOrderbook(index,symbols,depth,baseCollectorCallback);
          return;
        }
        const data = result.data;
        const timeStamp = data.timestamp;
        baseCollectorCallback(data.SELL.slice(0,depth).map((item)=>[item[0],item[1]]),data.BUY.slice(0,depth).map((item)=>[item[0],item[1]]),symbol,timeStamp);
        totalOrderbook[symbol]={asks:data.SELL,bids:data.BUY};
        this._requestSymbolFullOrderbook(index+1,symbols,depth,baseCollectorCallback);
      });
    }
  }

  _doSubscribeSymbols(symbols,callback,subscribeDepth){
  }

  _subscribeSymbols(symbols,callback,subscribeDepth){
    // this._fetchDepthByRest(symbols,subscribeDepth,callback);
    // this.api.subscribeSymbolsAndTicker(symbols,(error,result)=>{
    //   if(error){
    //     console.log(error);
    //   }else{
    //     //{"data":{"volume":0.03502337,"price":0.03367632,"count":1.04,"action":"ADD","time":1538538428679,"type":"BUY"},"topic":"/trade/ETH-BTC_TRADE","type":"message","seq":32748778883081}
    //
    //     const timeStamp = result.data.time;
    //     const symbol = result.data.topic.replace('/trade/','').replace('_TRADE','');
    //     const updateData = [[result.data.price,result.data.count]];
    //     let asks = totalOrderbook[symbol].asks|| [];
    //     let bids = totalOrderbook[symbol].bids|| [];
    //     if(result.data.type === 'BUY'){
    //       asks = mergeDepthAsk(asks,updateData);
    //     }else if(result.data.type === 'SELL'){
    //       bids = mergeDepthBid(bids,updateData);
    //     }
    //     if(symbol === 'NEO-BTC'){
    //       console.log("") //todo 这里输出日志，与网页对比
    //     }
    //     callback(asks.slice(0,subscribeDepth), bids.slice(0,subscribeDepth), symbol, timeStamp);
    //   }
    // })
    this._fetchDepthByWebsocket(symbols,subscribeDepth,callback)

  }
  _fetchDepthByRest(symbols,depth,callback){
    const restSymbols = symbols;
    for(let symbol of symbols){
      const midCurrency = symbol.split("-")[0];
      if(restCurrencies.includes(midCurrency)){
        restSymbols.push(symbol);
      }
    }
    const perInterval = 8;
    const totalInterval = perInterval * restSymbols.length;
    // const IPs = IPReader.allIps;
    setInterval(()=>{
      const sortedSymbols = restSymbols.sort(()=>{
        return Math.random()>0.5
      });
      for(let i=0;i<sortedSymbols.length;i++){
        const symbol = sortedSymbols[i];
        const ipAddress = IPs[i%IPs.length];
        setTimeout(()=>{
          this.api.getOrderbook(symbol,depth,ipAddress,(error,result)=>{
            if(error){
              console.error("get depth by rest error:");
              console.error(error);
              return;
            }
            const data = result.data;
            const timeStamp = data.timestamp;
            callback(data.SELL.slice(0,depth).map((item)=>[item[0],item[1]]),data.BUY.slice(0,depth).map((item)=>[item[0],item[1]]),symbol,timeStamp);
            totalOrderbook[symbol]={asks:data.SELL,bids:data.BUY};
          });
        },i*perInterval);
      }
    },totalInterval);
  }


  _fetchDepthByWebsocket(symbols, depth, callback){
    this.api.subscribeSymbols(symbols, depth, (error, result)=>{
      if(error){
        console.error("subscribe error");
        console.error(error);
      }else{
        console.log("subscribe success");
        return;
        const data = result.data;
        const timeStamp = result.timestamp;
        const symbol = result.symbol;
        callback(data.SELL.slice(0, depth).map((item)=>[item[0], item[1]]), data.BUY.slice(0, depth).map((item)=>[item[0], item[1]]), symbol, timeStamp);
      }
    })
  }

  _runMonitor(callback){
    let balanceMap = {};
    let need = 1;
    if(!coinInfoMap){
      console.log('start get coin info...');
      coinInfoMap = {}
      this.api.coins_info((error,result)=>{
        if(error){
          console.error('get coins info error')
        }else {
          if(result.data){
            for(let d of result.data){
              coinInfoMap[d.coin] = d
            }
          }
        }
      });
    }
    this.api.balance(20, 1, (error,result)=>{
      if(error){
        console.error("get balance by rest error:");
        console.error(error);
        return;
      }else{
        const balanceList = result.data.datas;
        for(let detail of balanceList){
          balanceMap[detail.coinType] = {available:(detail.balance - detail.freezeBalance),onOrder:detail.freezeBalance};
        }
        let pageNos = result.data.pageNos
        if(pageNos > 1){
          need = pageNos - 1;
          let amount = 0
          for(let i=2;i<=pageNos;i++){
            this.api.balance(20, i, (error,result)=>{
              amount += 1;
              if(error){
                console.error("get balance by rest error:");
                console.error(error);
                return;
              }else{
                const balanceList = result.data.datas;
                for(let detail of balanceList){
                  balanceMap[detail.coinType] = {available:(detail.balance - detail.freezeBalance),onOrder:detail.freezeBalance};
                }
              }
              if(need === amount){
                callback(balanceMap)
              }
            })
          }
        }else{
          const balanceList = result.data.datas;
          for(let detail of balanceList){
            balanceMap[detail.coinType] = {available:(detail.balance - detail.freezeBalance),onOrder:detail.freezeBalance};
          }
          callback(balanceMap)
        }
      }
    })
  }

  getSymbol(fromCurrency,toCurrency){
    let symbolDetail = this._getSymbolDetail(fromCurrency,toCurrency);
    return symbolDetail.symbol;
  }
  getFeeRate(fromCurrency,toCurrency){
    return 0.0009;
  }
  processAmount(fromCurrency,toCurrency,amount){
    //有可能会由于数值过小，传进来的amount被表示为科学计数法法
    const symbolDetail = this._getSymbolDetail(fromCurrency,toCurrency);
    const currency = symbolDetail.coinType;
    let tradePrecision = 4;
    const coin = coinInfoMap[currency];
    if(coin){
      tradePrecision = coin['tradePrecision'] || 4;
    }
    const amountStr = parseFloat(amount).toFixed(10);
    const nums = amountStr.split('.');
    if(nums.length ===2 && nums[1].length>tradePrecision){
      return nums[0]+"."+nums[1].slice(0,tradePrecision);
    }
    return amount;
  }
  processPrice(fromCurrency,toCurrency,price){
    // const amountStr = price+'';
    // const nums = amountStr.split('.');
    // if(nums.length ===2 && nums[1].length>4){
    //   return nums[0]+"."+nums[1].slice(0,4);
    // }
    return price;
  }
  getCurrencyMaxReturnAmount(currency){
    const balance = this.getCurrencyBalance(currency);
    return Math.min(Strategy3MaxAmountMap[currency],balance);
  }
  getDepthPrintStr(fromCurrency,toCurrency,depth=1){
    return super.getDepthPrintStr(fromCurrency,toCurrency,3);
  }

}

module.exports = BiboxCollector;

