const BaseCollector = require('./baseCollector');
const baseCurrencies = ["ETH","BTC","USDT", "NEO", "KCS"];
const machine = process.env['MACHINE'];
const biboxApi = require('./api_kucoin');
const IPs = require('./util');
let coinInfoMap = null;
// const totalOrderbook = {};
const Strategy3MaxAmountMap = {
  USDT: 300,
  BTC: 0.05,
  ETH: 1.5,
  NEO: 30,
  KCS: 600,
}

class KucoinCollector extends BaseCollector{
  constructor(wantedSymbols){
    super("KUCOIN",baseCurrencies,machine,wantedSymbols);
    this.api = new biboxApi('','');
  }
  _convertSymbolName(symbol){
    return symbol.replace("-","").toUpperCase();
  }
  _fetchSymbols(callback){
    this.api.fetchSymbols((error,data)=>{
      if(error){
        console.error("fetch symbol error");
        console.error(error);
        this._fetchSymbols(callback);
      }else{
        const symbolDetails = data.data;
        const symbolMap = {};
        for(let detail of symbolDetails){
          if(baseCurrencies.includes(detail.quoteCurrency) && detail.enableTrading){
            symbolMap[detail.symbol] = detail;
          }
        }
        callback(null,symbolMap);
      }
    })
  }

  _runMonitorInterval(){
    return 10 *1000;
  }

  _subscribeSymbols(symbols,callback,subscribeDepth){
    this._fetchDepthByWebsocket(symbols,subscribeDepth,callback)
    // setTimeout(()=>{
    //   this._fetchDepthByRest(symbols,subscribeDepth,callback);
    // },20000);
  }
  _fetchDepthByWebsocket(symbols, depth, callback){
    function subsCallback(error,result){
      if(error){
        console.error("subscribe error");
        console.error(error);
      }else{
        callback(result.asks.slice(0,depth), result.bids.slice(0,depth), result.symbol, result.timestamp);
      }
    }
    let buffer = [];
    for (let i = 0; i < symbols.length; i++) {
      buffer.push(symbols[i]);
      if (buffer.length === 95) {
        const subsBuffer = buffer;
        setTimeout(() => {
          this.api.subscribeSymbols(subsBuffer, depth, subsCallback)
        }, ((i + 1) / 10 - 1) * 50);
        buffer = [];
      }else if(i === symbols.length-1){
        setTimeout(() => {
          this.api.subscribeSymbols(buffer, depth, subsCallback)
        }, ((i + 1) / 10 - 1) * 50);
      }
    }
  }

  _runMonitor(callback){
    this.api.balance( (error,result)=>{
      if(error){
        console.error("get balance by rest error:");
        if(!error.data){
          console.error(error);
        }
        callback(null);
      }else{
        const balanceData = result.data;
        const balanceMap = {};
        for(const balance of balanceData){
          balanceMap[balance.currency] = {available:balance.available, onOrder:balance.holds};
        }
        callback(balanceMap);
      }
    })
  }

  getSymbol(fromCurrency,toCurrency){
    let symbolDetail = this._getSymbolDetail(fromCurrency,toCurrency);
    return symbolDetail.symbol;
  }
  getFeeRate(fromCurrency,toCurrency){
    // return 0.0007;
    return 0.001;
  }
  processAmount(fromCurrency,toCurrency,amount){
    const detail = this._getSymbolDetail(fromCurrency,toCurrency);

    if (detail) {
      const quantityIncrement = detail.baseIncrement;
      const minAmount = detail.baseMinSize;
      if(amount < minAmount){
        return 0;
      }
      const ratio = amount / quantityIncrement;
      if (ratio % 1 === 0) {
        return amount;
      }
      const amountScale = Math.round(Math.log(quantityIncrement) / Math.log(10));
      if (amountScale <= 0) {
        return parseFloat(amount).toFixed(Math.abs(amountScale));
      } else {
        return `${Math.floor(ratio) * quantityIncrement}`;
      }
    }
    return amount;
  }
  processPrice(fromCurrency,toCurrency,price){
    const detail = this._getSymbolDetail(fromCurrency,toCurrency);
    if (detail) {
      const tickSize = detail.priceIncrement;
      // console.log("tickSize是："+tickSize);
      const ratio = price / tickSize;
      if (ratio % 1 === 0) {
        return price;
      }
      const priceScale = Math.round(Math.log(tickSize) / Math.log(10));
      if (priceScale <= 0) {
        return parseFloat(price).toFixed(Math.abs(priceScale));
      } else {
        return `${Math.round(ratio) * tickSize}`;
      }
    }
    return price;
  }
  getCurrencyMaxReturnAmount(currency){
    // const balance = this.getCurrencyBalance(currency);
    // return Math.min(Strategy3MaxAmountMap[currency],balance);
    //todo
    return Strategy3MaxAmountMap[currency] || 1;
  }
  getDepthPrintStr(fromCurrency,toCurrency,depth=1){
    return super.getDepthPrintStr(fromCurrency,toCurrency,3);
  }


}

module.exports = KucoinCollector;

