const BaseCollector = require('./baseCollector');
const baseCurrencies = ["ETH","BTC","USDT", "NEO", "KCS"];
const restCurrencies = ["PRA","AAC","AT","RED","BU","QTUM","EOSDAC","HPB","ORME","TRX","TTC", "USDT","BTC","ETH", "NEO", "KCS", ];
const machine = process.env['MACHINE'];
const biboxApi = require('./api_kucoin');
const zlib = require('zlib');
let coinInfoMap = null
const Strategy3MaxAmountMap = {
  USDT: 300,
  BTC: 0.05,
  ETH: 1.5,
  NEO: 30,
  KCS: 600,
}

class BiboxCollector extends BaseCollector{
  constructor(wantedSymbols){
    super("KUCOIN",baseCurrencies,machine,wantedSymbols);
    this.api = new biboxApi('','');
  }
  _convertSymbolName(symbol){
    return symbol.replace("-","").toUpperCase();
  }
  _fetchSymbols(callback){
    this.api.fetchSymbols((error,data)=>{
      if(error){
        console.error("fetch symbol error");
        console.error(error);
        this._fetchSymbols(callback);
      }else{
        const symbolDetails = data.data;
        const symbolMap = {};
        for(let detail of symbolDetails){
          symbolMap[detail.symbol] = detail;
        }
        callback(null,symbolMap);
      }
    })
  }

  _runMonitorInterval(){
    return 10 *1000;
  }

  _subscribeSymbols(symbols,callback,subscribeDepth){
    this._fetchDepthByRest(symbols,subscribeDepth,callback);
    // this.api.subscribeSymbols(symbols,(error,data)=>{
    //    if(error){
    //      console.error("subscribe error");
    //      console.error(error);
    //    }else{
    //      const symbol = data['pair'];
    //      // const symbol = result.pair.replace("_","");
    //      const timeStamp = data['TS'];
    //      const depth = data['depth'];
    //      const asks = depth.asks.slice(0,subscribeDepth).map((item)=>[item[0],item[1]]);
    //      const bids = depth.bids.slice(0,subscribeDepth).map((item)=>[item[0],item[1]]);
    //      callback(asks, bids, symbol, timeStamp);
    //    }
    // })
  }
  _fetchDepthByRest(symbols,depth,callback){
    const restSymbols = symbols;
    // for(let symbol of symbols){
    //   const midCurrency = symbol.split("-")[0];
    //   if(restCurrencies.includes(midCurrency)){
    //     restSymbols.push(symbol);
    //   }
    // }
    const perInterval = 8;
    const totalInterval = perInterval * restSymbols.length;
    setInterval(()=>{
      const sortedSymbols = restSymbols.sort(()=>{
        return Math.random()>0.5
      });
      for(let i=0;i<sortedSymbols.length;i++){
        const symbol = sortedSymbols[i];
        setTimeout(()=>{
          this.api.getOrderbook(symbol,depth,(error,result)=>{
            if(error){
              console.error("get depth by rest error:");
              console.error(error);
              return;
            }
            const data = result.data;
            const timeStamp = data.timestamp;
            callback(data.SELL.map((item)=>[item[0],item[1]]),data.BUY.map((item)=>[item[0],item[1]]),symbol,timeStamp);
          })
        },i*perInterval);
      }
    },totalInterval);
  }

  _runMonitor(callback){
    let balanceMap = {};
    let need = 1;
    if(!coinInfoMap){
      console.log('start get coin info...');
      coinInfoMap = {}
      this.api.coins_info((error,result)=>{
        if(error){
          console.error('get coins info error')
        }else {
          if(result.data){
            for(let d of result.data){
              coinInfoMap[d.coin] = d
            }
          }
        }
      });
    }
    this.api.balance(20, 1, (error,result)=>{
      if(error){
        console.error("get balance by rest error:");
        console.error(error);
        return;
      }else{
        const balanceList = result.data.datas;
        for(let detail of balanceList){
          balanceMap[detail.coinType] = {available:(detail.balance - detail.freezeBalance),onOrder:detail.freezeBalance};
        }
        let pageNos = result.data.pageNos
        if(pageNos > 1){
          need = pageNos - 1;
          let amount = 0
          for(let i=2;i<=pageNos;i++){
            this.api.balance(20, i, (error,result)=>{
              amount += 1;
              if(error){
                console.error("get balance by rest error:");
                console.error(error);
                return;
              }else{
                const balanceList = result.data.datas;
                for(let detail of balanceList){
                  balanceMap[detail.coinType] = {available:(detail.balance - detail.freezeBalance),onOrder:detail.freezeBalance};
                }
              }
              if(need === amount){
                callback(balanceMap)
              }
            })
          }
        }else{
          const balanceList = result.data.datas;
          for(let detail of balanceList){
            balanceMap[detail.coinType] = {available:(detail.balance - detail.freezeBalance),onOrder:detail.freezeBalance};
          }
          callback(balanceMap)
        }
      }
    })
  }

  getSymbol(fromCurrency,toCurrency){
    let symbolDetail = this._getSymbolDetail(fromCurrency,toCurrency);
    return symbolDetail.symbol;
  }
  getFeeRate(fromCurrency,toCurrency){
    return 0.0009;
  }
  processAmount(fromCurrency,toCurrency,amount){
    //有可能会由于数值过小，传进来的amount被表示为科学计数法法
    const symbolDetail = this._getSymbolDetail(fromCurrency,toCurrency);
    const currency = symbolDetail.coinType;
    let tradePrecision = 4;
    const coin = coinInfoMap[currency];
    if(coin){
      tradePrecision = coin['tradePrecision'] || 4;
    }
    const amountStr = parseFloat(amount).toFixed(10);
    const nums = amountStr.split('.');
    if(nums.length ===2 && nums[1].length>tradePrecision){
      return nums[0]+"."+nums[1].slice(0,tradePrecision);
    }
    return amount;
  }
  processPrice(fromCurrency,toCurrency,price){
    // const amountStr = price+'';
    // const nums = amountStr.split('.');
    // if(nums.length ===2 && nums[1].length>4){
    //   return nums[0]+"."+nums[1].slice(0,4);
    // }
    return price;
  }
  getCurrencyMaxReturnAmount(currency){
    const balance = this.getCurrencyBalance(currency);
    return Math.min(Strategy3MaxAmountMap[currency],balance);
  }
  getDepthPrintStr(fromCurrency,toCurrency,depth=1){
    return super.getDepthPrintStr(fromCurrency,toCurrency,3);
  }

}

module.exports = BiboxCollector;

