const BaseCollector = require('./baseCollector');
const baseCurrencies = ["BIX","ETH","BTC","USDT"];
const machine = process.env['MACHINE'];
const biboxApi = require('./api_lbank');
const zlib = require('zlib');
const Strategy3MaxAmountMap = {
  USDT: 1000,
  BTC: 0.15,
  ETH: 1.5,
  BIX:600
}

class BiboxCollector extends BaseCollector{
  constructor(wantedSymbols){
    super("LBANK",baseCurrencies,machine,wantedSymbols);
    this.api = new biboxApi('','');
  }
  _convertSymbolName(symbol){
    return symbol.replace("_","").toUpperCase();
  }
  _fetchSymbols(callback){
    this.api.fetchSymbols((error,data)=>{
      if(error){
        console.error("fetch symbol error");
        console.error(error);
        this._fetchSymbols(callback);
      }else{
        const symbolDetails = data;
        const symbolMap = {};
        for(let detail of symbolDetails){
          symbolMap[detail.symbol] = detail;
        }
        callback(null,symbolMap);
      }
    })
  }

  _runMonitorInterval(){
    return 10 *1000;
  }

  _subscribeSymbols(symbols,callback,subscribeDepth){
    this.api.subscribeSymbols(symbols,(error,data)=>{
       if(error){
         console.error("subscribe error");
         console.error(error);
       }else{
         const symbol = data['pair'];
         // const symbol = result.pair.replace("_","");
         const timeStamp = data['TS'];
         const depth = data['depth'];
         const asks = depth.asks.slice(0,subscribeDepth).map((item)=>[item[0],item[1]]);
         const bids = depth.bids.slice(0,subscribeDepth).map((item)=>[item[0],item[1]]);
         callback(asks, bids, symbol, timeStamp);
       }
    })
  }
  _runMonitor(callback){
    this.api.balance((error,result)=>{
      if(error){
        console.error("get balance error");
        console.error(error);
        callback(null);
      }else{
        const balanceList = result.free;
        const balanceMap = {};
        for(let detail in balanceList){
          balanceMap[detail] = {available:balanceList[detail],onOrder:0};
        }
        const freezes = result.info.freeze;
        for(let fz in freezes){
          if(balanceMap[fz]){
            balanceMap[fz]['onOrder'] = freezes[fz];
          }else{
            balanceMap[fz] = {available:0,onOrder:freezes[fz]};
          }
        }
        callback(balanceMap);
      }
    })
  }

  getSymbol(fromCurrency,toCurrency){
    let symbolDetail = this._getSymbolDetail(fromCurrency,toCurrency);
    return symbolDetail.pair;
  }
  getFeeRate(fromCurrency,toCurrency){
    return 0.001;
  }
  processAmount(fromCurrency,toCurrency,amount){
    //有可能会由于数值过小，传进来的amount被表示为科学计数法法
    const amountStr = parseFloat(amount).toFixed(10);
    const nums = amountStr.split('.');
    if(nums.length ===2 && nums[1].length>4){
      return nums[0]+"."+nums[1].slice(0,4);
    }
    return amount;
  }
  processPrice(fromCurrency,toCurrency,price){
    // const amountStr = price+'';
    // const nums = amountStr.split('.');
    // if(nums.length ===2 && nums[1].length>4){
    //   return nums[0]+"."+nums[1].slice(0,4);
    // }
    return price;
  }
  getCurrencyMaxReturnAmount(currency){
    const balance = this.getCurrencyBalance(currency);
    return Math.min(Strategy3MaxAmountMap[currency],balance);
  }
  getDepthPrintStr(fromCurrency,toCurrency,depth=1){
    return super.getDepthPrintStr(fromCurrency,toCurrency,3);
  }

}

module.exports = BiboxCollector;

