const WebSocket = require('ws');
const SocksProxyAgent = require('socks-proxy-agent');
const proxy = process.env.agent;
const agent = proxy ? new SocksProxyAgent(proxy) : null;
// const zlib = require('zlib');
const wsUrl = 'wss://api.lbkex.com/ws/V2/';
const request = require('request');
const host = 'https://api.lbkex.com';
const CrytoJS = require('crypto-js');
const constants = require('./constants');


class lbankApi {
  constructor() {
    this.apiKey = '926468ad-9a27-4226-ae05-b23a22520f1d';
    this.apiSecret = 'MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAK0KVME06yIf/HeFyCnsVXX39UsUogBJr1HYgD6K3AgCBFLDq2ItF/xPrn1smkG8IiIl2qjxNIkykc74BWNGDhboftrPniPz+eshl+zWkTb1QEizbIs6h4Rcjfd1z0KF0/lgh5EnrMRT/V6x9JVkg9bSzOZPLNnWtX9nkJnE32UNAgMBAAECgYA9tnqFsWbOc9PpmJfLg9Ly0Kz1yvT/30eci/co1wMkA/wgvFIKIIT2YkCb0LivCvatcQyrxeJzr8paow/g2OI66Qw4eSfyKXjp5H+IfZ1xgP1hF+HnwHrP+CAGKa/PgqRhD9CTrU7a9keKeJ7Kuj1Q6iA3MucO+yvL573BzHanwQJBANtvjxj/PqCFjLXqM0qt9Tq83bS93obU1HaPXDXeQjr91CE37+vMLxyx5Xwr3IGgEI82cLCyUMmA2IX6ga3E1/0CQQDJ37Brma3Ezeo9WsHkDv1xquFIRjXyhzBG57NynAFT8IMcWoiO+GyXLl/leaZrZOU71Ot1gygP29LiOasbfaZRAkB7vte1wwswPt/xHpe6P4uRijyE1qYM5yzBh2r6vdIfrlDYQtE76jOPPQsrERkSyI9OE+dM3eINIGn6dCB5PA6JAkA1G4TU+cvuH2HFHFAvyAXC1nqHwfjFQe1gaeoad5Id3AMR/Xs5aX9f0lJmEzfFvvhTYjNDaeqrKWB0JUmvZMHRAkEAqbmHUVn8qOqeX7cSxJPgmquEvq0wAD5Wl8cYSM0hloB2EWQ0Z9BGliRq0u0j/qdM1GK/xyAPzBIuhD5/McldZQ==';
  }

  subscribeSymbols(symbols, callback) {
    const channels = symbols.map((item) => {
      return JSON.stringify({action: "subscribe", subscribe: "depth", depth: 10, pair: item});
    });
    const wss = new WebSocket(wsUrl, {agent});
    wss.on('open', () => {
      console.log("websocket on open");
      for (let channel of channels) {
        wss.send(channel);
      }
    });
    wss.on('message', (data) => {
      const response = JSON.parse(data);
      if (response['type'] === "depth") {
        callback(null, response);
      } else if(response['ping']){
        console.log('lbank ping')
        wss.send(JSON.stringify({"action": "pong", "pong": response['ping']}));
      } else {
        console.log(data);
        callback(response, null);
      }
    });
    wss.on('error', (error) => {
      console.log(" websocket error:");
      console.log(error);
    })
    wss.on('close', () => {
      console.log("websocket closed");
      this.subscribeSymbols(symbols, callback);
    })
  }

  transform(obj) {
    var str = [];
    for (var p in obj)
      str.push(encodeURIComponent(p) + "=" + encodeURIComponent(obj[p]));
    return str.join("&");
  }

  objKeySort(obj) {//排序的函数
    var newkey = Object.keys(obj).sort();
    //先用Object内置类的keys方法获取要排序对象的属性名，再利用Array原型上的sort方法对获取的属性名进行排序，newkey是一个数组
    var newObj = {};//创建一个新的对象，用于存放排好序的键值对
    for (var i = 0; i < newkey.length; i++) {//遍历newkey数组
      newObj[newkey[i]] = obj[newkey[i]];//向新创建的对象中按照排好的顺序依次增加键值对
    }
    return newObj;//返回排好序的新对象
  }

  _publicRequest(path, params, callback) {
    let url = host + path;
    if (params) {
      url += "?";
      const keys = Object.keys(params);
      for (let i = 0; i < keys.length; i++) {
        url += `${keys[i]}=${params[keys[i]]}`;
        if (i !== keys.length - 1) {
          url += "&";
        }
      }
    }
    const options = {
      url,
      method: 'GET',
      timeout: 8000,
      forever: true,
    };
    request(options, (error, response, body) => {
      if (error) {
        callback(error);
      } else {
        try {
          const result = JSON.parse(body);
          callback(null, result);
        } catch (e) {
          callback(e, null);
        }
      }
    });
  }

  _request(method, path, params, callback) {
    const url = host + path;
    params['apikey'] = this.apiKey;
    const md5Str = CrytoJS.MD5(this.transform(this.objKeySort(params))).toString();
    const sign = CrytoJS.HmacSHA256(md5Str, this.apiSecret).toString();
    params['sign'] = sign;

    const requestParams = {}
    requestParams["url"] = url;
    requestParams["method"] = method;
    requestParams["form"] = params;
    requestParams["timeout"] = 10000;
    requestParams["forever"] = true;
    request(requestParams, (error, response, body) => {
      if (error) {
        callback(error);
      } else {
        try {
          const result = JSON.parse(body);
          if (result.result) {
            callback(result, null);
          } else {
            callback(null, result);
          }
        } catch (e) {
          console.error("parse body时出错");
          console.error("status code:" + response.statusCode + ",body:" + response.body);
          // if (response.statusCode === 429) {
          // callback({statusCode: response.statusCode})
          // } else {
          callback(e, null);
          // }
        }
      }
    });
  }


  fetchSymbols(callback) {
    this._publicRequest('/v1/ticker.do', {"symbol": 'all'}, callback);
  }

  order(price, amount, symbol, side, callback) {
    //账户类型，0-普通账户，1-信用账户
    //交易类型，1-市价单，2-限价单
    //交易方向，1-买，2-卖
    const params = {
      type: side,
      symbol,
      price,
      amount
      // money:parseFloat(price) * parseFloat(amount)
    };
    this._request("POST", "/v1/create_order.do", params, callback)
  }

  balance(callback) {
    // this._request("POST", "/v1/user_info.do", {}, callback);
    const result = {
      "result": "true",
      "info": {
        "freeze": {},
        "asset": {},
        "free": {}
      }
    }
    callback(null, result);
  }

  getTrades(symbol, callback) {
    const params = {
      "symbol": symbol,
      "size": 10
    }
    this._publicRequest("/v1/trades.do", params, callback);
  }

  searchOrder(orderId, symbol, callback) {
    const params = {
      order_id: orderId,
      symbol
    }
    this._request("POST", "/v1/orders_info.do", params, callback);
  }

  cancelOrder(orderId, symbol, callback) {
    const params = {
      orders_id: orderId,
      symbol
    }
    this._request("POST", "/v1/cancel_order.do", params, callback);
  }

  fetchHistorOrders(page, size, symbol, side, callback) {
    const params = {
      symbol: symbol,
      current_page: page,
      page_length: size,
    };
    this._request("POST", "/v1/orders_info_history.do", params, callback);
  }
}

module.exports = lbankApi;