const WebSocket = require('ws');
const SocksProxyAgent = require('socks-proxy-agent');
const proxy = process.env.agent;
const agent = proxy ? new SocksProxyAgent(proxy) : null;
// const zlib = require('zlib');
// const wsUrl = 'wss://push.bibox.com/';
const request = require('request');
// const host = 'https://api.kucoin.com';
const host = 'https://api.kucoin.com';
const CrytoJS = require('crypto-js');
const constants = require('./constants');


class biboxApi {
  constructor() {
    this.apiKey = '61e6fa70476199d7245e2993b01d33ef14cb24dd';
    this.apiSecret = '269bdc93d18f9215814a6a25dc38a4a8915cd63a';
    this.allowRequest = true;
  }

  // subscribeSymbolsAndTicker(symbols, callback) {
  //   const channels = [];
  //   const tickers = [];
  //   // const channels = symbols.map((item) => {
  //   //   return JSON.stringify({event: "addChannel", "channel": `bibox_sub_spot_${item}_depth`, "binary": 1});
  //   // });
  //   for(let item of symbols){
  //     channels.push(JSON.stringify({event: "addChannel", "channel": `bibox_sub_spot_${item}_depth`, "binary": 1}));
  //     // tickers.push(JSON.stringify({event:"addChannel","channel":`bibox_sub_spot_${item}_ticker`,"binary":0}))
  //   }
  //   const wss = new WebSocket(wsUrl, {agent});
  //   wss.on('open', () => {
  //     console.log("websocket on open");
  //     for (let i=0;i<channels.length;i++) {
  //       wss.send(channels[i]);
  //       wss.send(tickers[i]);
  //     }
  //   });
  //   wss.on('message', (data) => {
  //     const response = JSON.parse(data);
  //     if (Array.isArray(response) && response.length && (response[0].channel.endsWith("depth") || response[0].channel.endsWith("ticker"))) {
  //       callback(null, response[0]);
  //     } else {
  //       console.log(data);
  //       callback(response, null);
  //     }
  //   });
  //   wss.on('error', (error) => {
  //     console.log(" websocket error:");
  //     console.log(error);
  //   })
  //   wss.on('close', () => {
  //     console.log("websocket closed");
  //     setTimeout(()=>{
  //       this.subscribeSymbolsAndTicker(symbols, callback);
  //     },2000);
  //   })
  // }

  _publicRequest(path, params, callback) {
    if(!this.allowRequest){
      callback({code:"-2",message:"出现超频情况，暂停提交请求"});
      return;
    }
    let url = host + path;
    if (params) {
      url += "?";
      const keys = Object.keys(params);
      for (let i = 0; i < keys.length; i++) {
        url += `${keys[i]}=${params[keys[i]]}`;
        if (i !== keys.length - 1) {
          url += "&";
        }
      }
    }
    const options = {
      url,
      method: 'GET',
      timeout: 8000,
      forever: true,
    };
    request(options, (error, response, body) => {
      if (error) {
        callback(error);
      } else {
        try {
          const result = JSON.parse(body);
          if (result.success && result.code === 'OK') {
            callback(null, result);
          } else {
            callback(result, null);
          }
        } catch (e) {
          console.log(e);
          callback({statusCode:response.statusCode}, null);
        }
      }
    });
  }

  _request(method, path, cmd, params, callback) {
    if(!this.allowRequest){
      callback({code:"-2",message:"出现超频情况，暂停提交请求"});
      return;
    }
    const url = host + path;
    const cmdStr = JSON.stringify([{"cmd": cmd, "body": params}]);
    const sign = CrytoJS.HmacMD5(cmdStr, this.apiSecret).toString();
    const form = {"cmds": cmdStr, "apikey": this.apiKey, "sign": sign};

    const requestParams = {};
    requestParams["url"] = url;
    requestParams["method"] = method;
    requestParams["form"] = form;
    requestParams["timeout"] = 10000;
    requestParams["forever"] = true;
    request(requestParams, (error, response, body) => {
      if (error) {
        callback(error);
      } else {
        try {
          const result = JSON.parse(body);
          if (result.error) {
            callback(result.error, null);
            if(result.error.code == '2091' && this.allowRequest){
              this.allowRequest = false;
              console.log("请求超频，将会暂停发送请求");
              setTimeout(()=>{
                this.allowRequest = true;
              },1000 * 60 * 5);
            }
          } else {
            callback(null, result.result[0]);
          }
        } catch (e) {
          console.error("parse body时出错");
          console.error("status code:" + response.statusCode + ",body:" + response.body);
          // if (response.statusCode === 429) {
          // callback({statusCode: response.statusCode})
          // } else {
            callback(e, null);
          // }
        }
      }
    });
  }


  fetchSymbols(callback) {
    this._publicRequest('/v1/market/open/symbols', {}, callback);
  }

  order(price, amount, symbol, side, callback) {
    //账户类型，0-普通账户，1-信用账户
    //交易类型，1-市价单，2-限价单
    //交易方向，1-买，2-卖
    const params = {
      pair: symbol,
      account_type: 0,
      order_type: 2,
      order_side: side === constants.OrderSideBuy ? 1 : 2,
      pay_bix: 1,
      price,
      amount,
      // money:parseFloat(price) * parseFloat(amount)
    };

    this._request("POST", "/v1/orderpending", "orderpending/trade", params, callback)
  }

  balance(callback) {
    this._request("POST", "/v1/transfer", "transfer/assets", {select: 1}, callback);
  }

  getTrades(symbol, callback) {
    const params = {
      "cmd": "deals",
      "pair": symbol,
      "size": 10
    }
    this._publicRequest("/v1/mdata", params, callback);
  }

  searchOrder(orderId, callback) {
    const params = {
      id: orderId
    }
    this._request("POST", "/v1/orderpending", "orderpending/order", params, callback);
  }

  cancelOrder(orderId, callback) {
    const params = {
      orders_id: orderId
    }
    this._request("POST", "/v1/orderpending", "orderpending/cancelTrade", params, callback);
  }

  fetchHistorOrders(page,size,symbol,side,callback){
    const params = {
      pair:symbol,
      account_type:0,
      page,
      size,
      order_side:side === constants.OrderSideBuy ? 1 : 2,
      hide_cancel:0
    };
    this._request("POST","/v1/orderpending","orderpending/pendingHistoryList",params,callback);
  }
  getOrderbook(symbol,depth,callback){
    this._publicRequest("/v1/open/orders",{"symbol":symbol},callback);
  }
}

module.exports = biboxApi;