const constants = require('./constants');
const biboxApi = require('./api_kucoin');

// const StateFilled = 3;
// const StateNew = 1;
// const StatePartiallyFilled = 2;
// const StatePartiallyCancelled = 4;
// const StateCancelled = 5;
// const StateCancelling = 6;

function returnFakeOrder(symbol, price, amount) {
  return {
    orderId: "testOrder",
    price: price,
    status: constants.OrderStatusCanceled,
    transactTime: Date.now(),
    origQty: amount,
    executedQty: 0,
    symbol: symbol,
  }
}

function convertToRecordOrder(order, price) {
  console.log("convert to record order");
  console.log(order);
  let status = constants.OrderStatusNew;
  if(order.dealSize == order.size){
    status = constants.OrderStatusFilled;
  }else{
    if(order.dealSize > 0){
      status = constants.OrderStatusPartiallyFilled;
    }
    if(!order.isActive){
      status = constants.OrderStatusCanceled;
    }
  }
  return {
    orderId: order.id + '',
    price: price,
    status: status,
    transactTime: order.createdAt,
    origQty: order.size,
    executedQty: order.dealSize,
    symbol: order.symbol,
    side: order.side,
    fee:order.fee,
  }
}

function isTimeOutError(error){
  return error.code === 'ESOCKETTIMEDOUT' || error.code === 'ETIMEDOUT';
}

class Order {
  constructor() {
    this.api = new biboxApi();
  }

  _handleFOKSearchResult(orderId, symbol, side, price, finalCallback, error, result) {
    if (error) {
      console.error("搜索订单出错");
      console.error(error);
      let timeout = 100;
      setTimeout(() => {
        this.api.searchOrder(orderId, symbol, side, this._handleFOKSearchResult.bind(this, orderId, symbol, side, price, finalCallback));
      }, timeout);
      return;
    }
    const order = result.data || {};
    if(!order.dealAmount && !order.pendingAmount){
      console.error("没有返回amount 和deal amount字段，继续搜索");
      this.api.searchOrder(orderId, symbol, side, this._handleFOKSearchResult.bind(this, orderId, symbol, side, price, finalCallback));
    }else if (order.pendingAmount === 0 || !order.isActive) {
      finalCallback(null, convertToRecordOrder(order, price));
    } else if (order.dealAmount === 0 || (order.dealAmount > 0 && order.pendingAmount >0)) {
      this.api.cancelOrder(orderId, symbol, side, (error, result) => {
        // setTimeout(() => {
        console.log("尝试取消，准备搜索订单");
          this.api.searchOrder(orderId, symbol, side, this._handleFOKSearchResult.bind(this, orderId, symbol, side, price, finalCallback));
        // }, 80)
      })
    } else {
      setTimeout(() => {
      console.log("订单尚未完成或取消，再次搜索");
        this.api.searchOrder(orderId, symbol, side, this._handleFOKSearchResult.bind(this, orderId, symbol, side, price, finalCallback));
      }, 500);
    }
  }

  // FOKLikeOrder(symbol, price, amount, side, callback) {
  //   if (!constants.RealOrder) {
  //     callback(null, returnFakeOrder(symbol, price, amount));
  //     return;
  //   }
  //   this.api.order(price, amount, symbol, side, (error, result) => {
  //     if (error) {
  //       callback(error, null);
  //       return;
  //     }
  //     const orderId = result.data.orderOid;
  //     setTimeout(()=>{
  //       this.api.searchOrder(orderId, symbol, side, this._handleFOKSearchResult.bind(this, orderId, symbol, side, price, callback));
  //     },100);
  //   })
  // }

  order(symbol, price, amount, side,timeInForce, callback) {
    const cliordId = Date.now()+Math.floor(Math.random() * 100)+'';
    this.api.order(cliordId, price, amount, symbol, side, timeInForce, (error, result) => {
      if (error) {
        callback(error, null);
        return;
      }
      const orderId = result.data.orderId;
      const api2 = this.api;

      function handleSearchResult(error, result) {
        if (error) {
          console.error("搜索订单出错");
          console.error(error);
          // let timeout = 100;
          // setTimeout(() => {
            api2.searchOrder(orderId, handleSearchResult.bind(this));
          // }, timeout);
        }
        if(!result || !result.data){
          console.error("没有返回数据，再次搜索");
          api2.searchOrder(orderId,  handleSearchResult.bind(this));
          return;
        }
        if(timeInForce === constants.TimeInForceIOC && result.data.isActive){
          setTimeout(()=>{
            api2.searchOrder(orderId, handleSearchResult.bind(this));
          },200);
        }else{
          callback(null, convertToRecordOrder(result.data, price));
        }
      }

      this.api.searchOrder(orderId, handleSearchResult.bind(this));
    })
  }
}

module.exports = Order;