const request = require('request');
const constants = require('./constants');


module.exports = class Service {
  constructor(ip, port = 8300,platform) {
    this.ip = ip;
    this.port = port;
    this.platform = platform;
  }

  saveOrder({origQty, fromCurrency, toCurrency, price, orderId, executedQty, status, remark, operationType, source, relatedRecordId}, callback) {
    const url = `http://${constants.RecordHost}:${constants.RecordPort}/${constants.SaveOrderPath}`;
    // console.log("do save order:"+fromCurrency+"=>"+toCurrency+" @amount:"+origQty+" @price:"+price);
    request.post(url, {
      form: {
        prefer_amount: origQty,
        from_currency: fromCurrency.toUpperCase(),
        to_currency: toCurrency.toUpperCase(),
        prefer_price: price,
        price,
        platform_id: orderId,
        amount: executedQty,
        state: status,
        remark,
        operation_type: operationType,
        source,
        related_record: relatedRecordId,
        platform: this.platform,
      }
    }, (err, res) => {
      if (err) {
        console.log("save order error:" + relatedRecordId);
        console.error(err);
      } else if (callback) {
        callback(null, JSON.parse(res.body));
      }
    });
  }

  saveRecord({buyPrice, sellPrice, returnPrice, buyFromCurrency, buyToCurrency, sellToCurrency, buyRemark, sellRemark, returnRemark}, callback) {
    const url = `http://${constants.RecordHost}:${constants.RecordPort}/${constants.SaveRecordPath}`;
    request.post(url, {
      form: {
        buy_price: buyPrice,
        sell_price: sellPrice,
        return_price: returnPrice,
        buy_from_currency: buyFromCurrency.toUpperCase(),
        buy_to_currency: buyToCurrency.toUpperCase(),
        sell_from_currency: buyToCurrency.toUpperCase(),
        sell_to_currency: sellToCurrency.toUpperCase(),
        buy_remark: buyRemark,
        sell_remark: sellRemark,
        return_remark: returnRemark,
        buy_platform: this.platform,
        sell_platform: this.platform,
        return_platform: this.platform,
      }
    }, (err, res) => {
      if (err) {
        console.log("save record error");
        console.error(err);
      } else if (callback) {
        callback(null, JSON.parse(res.body))
        // const fakeId = Date.now() + ''
        // callback(null, {data: {id: fakeId}})
      }
    });
  }
}