const WebSocket = require('ws');
const SocksProxyAgent = require('socks-proxy-agent');
const proxy = process.env.agent;
const agent = proxy ? new SocksProxyAgent(proxy) : null;
const wsUrl = 'wss://push1.kucoin.com/endpoint';
const request = require('request');
const host = 'https://api.kucoin.com';
const CryptoJS = require('crypto-js');
const constants = require('./constants');
const {IPs, mergeDepth} = require('./util');
let totalOrderbook = {};

let getUpdatedData = function (currentData, response) {
  const updateData = [];
  let newCount = 0;
  let has = false;
  for (const a of currentData) {
    if (response.data.price === a[0]) {
      has = true;
      newCount = a[1];
      if (response.data.action === 'ADD') {
        newCount += response.data.count;
      }
      else if (response.data.action === 'CANCEL') {
        newCount -= response.data.count;
        if(newCount <0){
          newCount = 0;
        }
      }
      break;
    }
  }
  if (!has) {
    if(response.data.action !== 'CANCEL')
      updateData.push([response.data.price, response.data.count]);
  } else {
    // updateData = [[response.data.price, newCount]];
    updateData.push([response.data.price, newCount]);
  }
  return updateData;
};

class biboxApi {
  constructor() {
    this.apiKey = '5ba054d2e0abb830dee81e1d';
    this.apiSecret = 'baa55ba9-7290-431e-9fd4-42aa4598887f';
    this.allowRequest = true;
  }

  subscribeSymbolsAndTicker(symbols, callback) {
    this._publicRequest('/v1/bullet/usercenter/loginUser',{protocol:'websocket',encrypt:true},(error,result)=>{
      if(error){
        console.log("fetch ws token error");
        this.subscribeSymbolsAndTicker(symbols,callback);
      }else{
        const token = result.data.bulletToken;
        this._doSubscribe(symbols,token,callback);
      }
    });
  }


  _doSubscribe(symbols,token, callback) {
    const reqURL = `${wsUrl}?bulletToken=${token}&format=json&resource=api`;
    const wss = new WebSocket(reqURL, {agent});
    wss.on('open', () => {
      console.log("websocket on open");
    });
    wss.on('message', (data) => {
      const response = JSON.parse(data);
      if(response.type === 'ack'){
        const id = response.id;
        for(const symbol of symbols){
          wss.send(JSON.stringify({id,type:'subscribe','topic':`/trade/${symbol}_TRADE`}))
        }
        setInterval(()=>{
          wss.send(JSON.stringify({id,type:'ping'}))
        },40000);
      }else if(response.type === 'subscribe'){
         callback(null,response);
      }else{
        console.log(data);
      }
    });
    wss.on('error', (error) => {
      console.log(" websocket error:");
      console.log(error);
    })
    wss.on('close', () => {
      console.log("websocket closed");
      setTimeout(() => {
        this.subscribeSymbolsAndTicker(symbols, callback);
      }, 2000);
    })
  }

  subscribeSymbols(symbols, depth, callback) {
    this._publicRequest('/v1/bullet/usercenter/loginUser',{protocol:'websocket',encrypt:true},(error,result)=>{
      if(error){
        console.log("fetch ws token error");
        this.subscribeSymbols(symbols, depth, callback);
      }else{
        const token = result.data.bulletToken;
        const reqURL = `${wsUrl}?bulletToken=${token}&format=json&resource=api`;
        const wss = new WebSocket(reqURL, {agent});
        wss.on('open', () => {
          console.log("websocket on open");
        });
        wss.on('message', (data) => {
          const response = JSON.parse(data);
          if(response.type === 'ack'){
            const id = response.id;
            setInterval(()=>{
              if(wss.readyState === constants.SocketReadyStateOpen){
                wss.send(JSON.stringify({id,type:'ping'}))
              }
            },40000);
            for(const symbol of symbols){
              this._subscribeSymbol(wss, id, symbol, depth)
            }
          }else if(response.topic && response.topic.startsWith('/trade')){
            const timeStamp = response.data.time;
            const symbol = response.topic.replace('/trade/','').replace('_TRADE','');
            let asks = totalOrderbook[symbol].asks || [];
            let bids = totalOrderbook[symbol].bids || [];
            if(response.data.type === 'SELL'){
              const updateData = getUpdatedData(asks, response);
              asks = mergeDepth(asks, updateData, true);
            }else if(response.data.type === 'BUY'){
              const updateData = getUpdatedData(bids,response);
              bids = mergeDepth(bids, updateData, false);
            }
            totalOrderbook[symbol].bids = bids;
            totalOrderbook[symbol].asks = asks;
            const ret = {data: {SELL: asks, BUY: bids}, timestamp: timeStamp, symbol: symbol}
            callback(null,ret);
          }else{
            // console.log(data);
          }
        });
        wss.on('error', (error) => {
          console.log("websocket error:");
          console.log(error);
        })
        wss.on('close', () => {
          console.log("websocket closed");
          setTimeout(() => {
            this.subscribeSymbols(symbols, depth, callback);
          }, 2000);
        })
      }
    });
  }

  _subscribeSymbol(wss, id, symbol, depth){
    const ipAddress = IPs[Math.round(Math.random()*(IPs.length-1))];
    this.getOrderbook(symbol,depth,ipAddress,(error,result)=>{
      if(error){
        console.error("get symbol by rest error:");
        console.error(error);
        this._subscribeSymbol(wss,id,symbol,depth);
        return;
      }
      const data = result.data;
      totalOrderbook[symbol]={asks:data.SELL,bids:data.BUY};
      wss.send(JSON.stringify({id,type:'subscribe','topic':`/trade/${symbol}_TRADE`}))
    });
  }

  transform(obj) {
    var str = [];
    for (var p in obj)
      str.push(encodeURIComponent(p) + "=" + encodeURIComponent(obj[p]));
    return str.join("&");
  }

  objKeySort(obj) {//排序的函数
    var newkey = Object.keys(obj).sort();
    //先用Object内置类的keys方法获取要排序对象的属性名，再利用Array原型上的sort方法对获取的属性名进行排序，newkey是一个数组
    var newObj = {};//创建一个新的对象，用于存放排好序的键值对
    for (var i = 0; i < newkey.length; i++) {//遍历newkey数组
      newObj[newkey[i]] = obj[newkey[i]];//向新创建的对象中按照排好的顺序依次增加键值对
    }
    return newObj;//返回排好序的新对象
  }

  _publicRequest(path, params,callback,bindIP) {
    if(!this.allowRequest){
      callback({code:"-2",message:"出现超频情况，暂停提交请求"});
      return;
    }
    let url = host + path;
    if (params) {
      url += "?";
      const keys = Object.keys(params);
      for (let i = 0; i < keys.length; i++) {
        url += `${keys[i]}=${params[keys[i]]}`;
        if (i !== keys.length - 1) {
          url += "&";
        }
      }
    }
    const options = {
      url,
      method: 'GET',
      timeout: 8000,
      forever: true,
      localAddress:bindIP,

    };
    request(options, (error, response, body) => {
      if (error) {
        callback(error);
      } else {
        try {
          const result = JSON.parse(body);
          if (result.success) {
            callback(null, result);
          } else {
            callback(result, null);
          }
        } catch (e) {
          // console.error(e);
          // console.error(body);
          callback({statusCode:response.statusCode}, null);
        }
      }
    });
  }

  _request(method, path, params, callback) {
    if(!this.allowRequest){
      callback({code:"-2",message:"出现超频情况，暂停提交请求"});
      return;
    }
    let url = host + path;
    const nonce = new Date().getTime();
    const strParams = this.transform(this.objKeySort(params));
    const strForSign = path + '/' +  nonce + '/' + strParams;
    const strForSign2 = CryptoJS.enc.Base64.stringify(CryptoJS.enc.Utf8.parse(strForSign))
    const sign = CryptoJS.HmacSHA256(strForSign2, this.apiSecret).toString(CryptoJS.enc.Hex);
    const headers = {
      "Accept-Language": "zh_CN",
      'KC-API-KEY': this.apiKey,
      'KC-API-NONCE': nonce,
      'KC-API-SIGNATURE': sign
    }
    const requestParams = {};
    let form = params
    if (method === 'GET'){
      url += '?' + this.transform(params);
      form = {}
    }
    requestParams["url"] = url;
    requestParams["method"] = method;
    requestParams["headers"] = headers;
    requestParams["form"] = form;
    requestParams["timeout"] = 10000;
    requestParams["forever"] = true;
    request(requestParams, (error, response, body) => {
      if (error) {
        callback(error);
      } else {
        try {
          const result = JSON.parse(body);
          if (result.success && result.code === 'OK') {
            callback(null, result);
          } else {
            callback(result, null);
          }
        } catch (e) {
          console.error("parse body时出错");
          console.error("status code:" + response.statusCode);
          callback(e, null)
          // if (response.statusCode === 429) {
          // callback({statusCode: response.statusCode})
          // } else {
          //   callback(e, null);
          // }
        }
      }
    });
  }


  fetchSymbols(callback) {
    this._publicRequest('/v1/market/open/symbols', {}, callback);
  }

  order(price, amount, symbol, side, callback) {
    //账户类型，0-普通账户，1-信用账户
    //交易类型，1-市价单，2-限价单
    //交易方向，1-买，2-卖
    const params = {
      symbol: symbol,
      type: side === constants.OrderSideBuy ? 'BUY' : 'SELL',
      pay_bix: 1,
      price,
      amount,
    };

    this._request("POST", "/v1/order", params, callback)
  }

  balance(limit, page, callback) {
    this._request("GET", "/v1/account/balances",{limit: limit || 20, page: page || 1}, callback);
  }

  coins_info(callback) {
    this._publicRequest("/v1/market/open/coins",{}, callback);
  }

  getTrades(symbol, callback) {
    callback(null, null)
  }

  searchOrder(orderId, symbol, side, callback) {
    const params = {
      symbol: symbol,
      type: side === constants.OrderSideBuy ? 'BUY' : 'SELL',
      orderOid: orderId
    }
    this._request("GET", "/v1/order/detail",  params, callback);
  }

  cancelOrder(orderId, symbol, side, callback) {
    const params = {
      symbol: symbol,
      orderOid: orderId,
      type: side === constants.OrderSideBuy ? 'BUY' : 'SELL',
    }
    this._request("POST", "/v1/cancel-order", params, callback);
  }

  fetchHistorOrders(page,size,symbol,side,callback){
    const params = {
      pair:symbol,
      account_type:0,
      page,
      size,
      order_side:side === constants.OrderSideBuy ? 1 : 2,
      hide_cancel:0
    };
    this._request("POST","/v1/orderpending","orderpending/pendingHistoryList",params,callback);
  }
  getOrderbook(symbol,depth,bindIP,callback){
    this._publicRequest("/v1/open/orders",{"symbol":symbol,"limit":20},callback,bindIP);
  }
}

module.exports = biboxApi;