const WebSocket = require('ws');
const SocksProxyAgent = require('socks-proxy-agent');
const proxy = process.env.agent;
const agent = proxy ? new SocksProxyAgent(proxy) : null;
// const zlib = require('zlib');
// const wsUrl = 'wss://push.bibox.com/';
const request = require('request');
// const host = 'https://api.kucoin.com';
const host = 'https://api.kucoin.com';
const CryptoJS = require('crypto-js');
const constants = require('./constants');


class biboxApi {
  constructor() {
    this.apiKey = '5ba054d2e0abb830dee81e1d';
    this.apiSecret = 'baa55ba9-7290-431e-9fd4-42aa4598887f';
    this.allowRequest = true;
  }

  // subscribeSymbolsAndTicker(symbols, callback) {
  //   const channels = [];
  //   const tickers = [];
  //   // const channels = symbols.map((item) => {
  //   //   return JSON.stringify({event: "addChannel", "channel": `bibox_sub_spot_${item}_depth`, "binary": 1});
  //   // });
  //   for(let item of symbols){
  //     channels.push(JSON.stringify({event: "addChannel", "channel": `bibox_sub_spot_${item}_depth`, "binary": 1}));
  //     // tickers.push(JSON.stringify({event:"addChannel","channel":`bibox_sub_spot_${item}_ticker`,"binary":0}))
  //   }
  //   const wss = new WebSocket(wsUrl, {agent});
  //   wss.on('open', () => {
  //     console.log("websocket on open");
  //     for (let i=0;i<channels.length;i++) {
  //       wss.send(channels[i]);
  //       wss.send(tickers[i]);
  //     }
  //   });
  //   wss.on('message', (data) => {
  //     const response = JSON.parse(data);
  //     if (Array.isArray(response) && response.length && (response[0].channel.endsWith("depth") || response[0].channel.endsWith("ticker"))) {
  //       callback(null, response[0]);
  //     } else {
  //       console.log(data);
  //       callback(response, null);
  //     }
  //   });
  //   wss.on('error', (error) => {
  //     console.log(" websocket error:");
  //     console.log(error);
  //   })
  //   wss.on('close', () => {
  //     console.log("websocket closed");
  //     setTimeout(()=>{
  //       this.subscribeSymbolsAndTicker(symbols, callback);
  //     },2000);
  //   })
  // }


  transform(obj) {
    var str = [];
    for (var p in obj)
      str.push(encodeURIComponent(p) + "=" + encodeURIComponent(obj[p]));
    return str.join("&");
  }

  objKeySort(obj) {//排序的函数
    var newkey = Object.keys(obj).sort();
    //先用Object内置类的keys方法获取要排序对象的属性名，再利用Array原型上的sort方法对获取的属性名进行排序，newkey是一个数组
    var newObj = {};//创建一个新的对象，用于存放排好序的键值对
    for (var i = 0; i < newkey.length; i++) {//遍历newkey数组
      newObj[newkey[i]] = obj[newkey[i]];//向新创建的对象中按照排好的顺序依次增加键值对
    }
    return newObj;//返回排好序的新对象
  }

  _publicRequest(path, params, callback) {
    if(!this.allowRequest){
      callback({code:"-2",message:"出现超频情况，暂停提交请求"});
      return;
    }
    let url = host + path;
    if (params) {
      url += "?";
      const keys = Object.keys(params);
      for (let i = 0; i < keys.length; i++) {
        url += `${keys[i]}=${params[keys[i]]}`;
        if (i !== keys.length - 1) {
          url += "&";
        }
      }
    }
    const options = {
      url,
      method: 'GET',
      timeout: 8000,
      forever: true,
    };
    request(options, (error, response, body) => {
      if (error) {
        callback(error);
      } else {
        try {
          const result = JSON.parse(body);
          if (result.success && result.code === 'OK') {
            callback(null, result);
          } else {
            callback(result, null);
          }
        } catch (e) {
          console.log(e);
          callback({statusCode:response.statusCode}, null);
        }
      }
    });
  }

  _request(method, path, params, callback) {
    if(!this.allowRequest){
      callback({code:"-2",message:"出现超频情况，暂停提交请求"});
      return;
    }
    let url = host + path;
    const nonce = new Date().getTime();
    const strParams = this.transform(this.objKeySort(params));
    const strForSign = path + '/' +  nonce + '/' + strParams;
    const strForSign2 = CryptoJS.enc.Base64.stringify(CryptoJS.enc.Utf8.parse(strForSign))
    const sign = CryptoJS.HmacSHA256(strForSign2, this.apiSecret).toString(CryptoJS.enc.Hex);
    const headers = {
      "Accept-Language": "zh_CN",
      'KC-API-KEY': this.apiKey,
      'KC-API-NONCE': nonce,
      'KC-API-SIGNATURE': sign
    }
    console.log(headers)
    const requestParams = {};
    let form = params
    if (method === 'GET'){
      url += '?' + this.transform(params);
      form = {}
    }
    requestParams["url"] = url;
    requestParams["method"] = method;
    requestParams["headers"] = headers;
    requestParams["form"] = form;
    requestParams["timeout"] = 10000;
    requestParams["forever"] = true;
    request(requestParams, (error, response, body) => {
      if (error) {
        callback(error);
      } else {
        try {
          const result = JSON.parse(body);
          if (result.success && result.code === 'OK') {
            callback(null, result);
          } else {
            callback(result, null);
          }
        } catch (e) {
          console.error("parse body时出错");
          console.error("status code:" + response.statusCode + ",body:" + response.body);
          callback(e, null)
          // if (response.statusCode === 429) {
          // callback({statusCode: response.statusCode})
          // } else {
          //   callback(e, null);
          // }
        }
      }
    });
  }


  fetchSymbols(callback) {
    this._publicRequest('/v1/market/open/symbols', {}, callback);
  }

  order(price, amount, symbol, side, callback) {
    //账户类型，0-普通账户，1-信用账户
    //交易类型，1-市价单，2-限价单
    //交易方向，1-买，2-卖
    const params = {
      symbol: symbol,
      type: side === constants.OrderSideBuy ? 'BUY' : 'SELL',
      pay_bix: 1,
      price,
      amount,
    };

    this._request("POST", "/v1/order", params, callback)
  }

  balance(limit, page, callback) {
    this._request("GET", "/v1/account/balances",{limit: limit || 20, page: page || 1}, callback);
  }

  getTrades(symbol, callback) {
    callback(null, null)
  }

  searchOrder(orderId, symbol, side, callback) {
    const params = {
      symbol: symbol,
      type: side === constants.OrderSideBuy ? 'BUY' : 'SELL',
      orderOid: orderId
    }
    this._request("GET", "/v1/order/detail",  params, callback);
  }

  cancelOrder(orderId, symbol, side, callback) {
    const params = {
      symbol: symbol,
      orderOid: orderId,
      type: side === constants.OrderSideBuy ? 'BUY' : 'SELL',
    }
    this._request("POST", "/v1/cancel-order", params, callback);
  }

  fetchHistorOrders(page,size,symbol,side,callback){
    const params = {
      pair:symbol,
      account_type:0,
      page,
      size,
      order_side:side === constants.OrderSideBuy ? 1 : 2,
      hide_cancel:0
    };
    this._request("POST","/v1/orderpending","orderpending/pendingHistoryList",params,callback);
  }
  getOrderbook(symbol,depth,callback){
    this._publicRequest("/v1/open/orders",{"symbol":symbol},callback);
  }
}

module.exports = biboxApi;