const WebSocket = require('ws');
const SocksProxyAgent = require('socks-proxy-agent');
const proxy = process.env.agent;
const agent = proxy ? new SocksProxyAgent(proxy) : null;
const zlib = require('zlib');
const BiboxCollector = require('./kucoinCollector');
const biboxApi = require('./api_kucoin');
const constants = require('./constants');
const Order = require('./order');



function testWs() {
  this.ws = new WebSocket('wss://push.bibox.com/', {agent});
  const wss = this.ws;
  this.ws.on('open', () => {
    console.log("成功启动collector");
    wss.send(JSON.stringify({"event":"addChannel","channel":"bibox_sub_spot_BTC_USDT_depth","binary":0}));
  });

  this.ws.on('message', (data)=>{
    // console.log(data);
    const response = JSON.parse(data)[0];
    const decodeStr = Buffer.from(response.data,'base64');
    zlib.unzip(decodeStr,(result1,result2)=>{
      console.log(result1);
      console.log(result2.toString());
    })
  });
  this.ws.on('error', (error) => {
    console.log("collector websocket error:");
    console.log(error);
  })
  this.ws.on('close', () => {
    console.log("websocket closed");
  })
}
// testWs();
function testCollector(){
  const collector = new BiboxCollector(null);
  collector.runStrategy3();

  const BiboxStrategy3 = require('./lbankStrategy3');
  const strategy3 = new BiboxStrategy3(collector);
  strategy3.run();
}
testCollector();

function printCurrency(){
  const currentArray = [,'ETH','BTC','LTC','BCH','USDT','USD','RMB',"RCN","WINGS","TRX","LEND","CMT","POWR","HSR","GAS","RDN","TNT","OAX"
    ,"ELF","GXS","ETC","FUN","ENG","LUN","BRD","ADA","RLC","SUB","REQ","SNT","SALT","QTUM","VIB","ARN","BCD","EOS"
    ,"AST","LRC","APPC","VIA","STEEM","LINK","XRP","ADX","XZC"
    ,"INS","STRAT","LTC","TRIG","GVT","CDT","ENJ","IOST","BNT","SNM","TNB","BTS","EDO","DNT","ICN","VIBE","RPX","ARK","NAV","DGD"
    ,"AION","CTR","OST","VEN","BLZ","MOD","XMR","NULS","NCASH","BNB","XVG","MCO"
    ,"IOTA","AE","OMG","WTC","NEBL","BCPT","DLT","ZRX","PIVX","CND","BCC","XLM","BAT"
    ,"FUEL","GTO","YOYO","SNGLS","ICX","STORJ","QSP"
    ,"BQX","PPT","MANA","MDA","MTL","WABI","DASH","WAVES","ZEC","KNC","NANO","EVX","CHAT","LSK","BTG"
    ,"NEO","POE","MTH","AMB","KMD","POA","ONT","ZIL","STORM","BCN","DOGE","DSH","EMC"
    ,"FCN","NXT","QCN","SBD","SC","XDN","XEM","ARDR","MAID","AMP","BUS","1ST","TRST","TIME","GNO"
    ,"REP","ZRC","BOS","DCT","ANT","AEON","GUP","PLU","TAAS","NXC","EDG","SWT","TKN","XAUR","PTOY","CFI"
    ,"PLBT","XDNCO","FYN","CVC","PAY","XTZ","DICE","NET","SNC","BET","DENT","SAN","MNE"
    ,"MSP","DDF","UET","MYB","SUR","IXT","PLR","TIX","NDC","PRO","AVT","COSS","QAU","FYP","OPT","STX","CAT","XUC","BAS","RVT","ICOS","PPC","VERI"
    ,"IGNIS","PRG","BMC","SKIN","EMGO","HVN","MCAP","AIR","NTO","ICO","PING"
    ,"RKC","GAME","TKR","HPC","WMGO","CSNO","ORME","PIX","IND","KICK","YOYOW","MIPS","DGB","DCN","LAT","CCT","EBET","VOISE","ZSC"
    ,"ETBS","ART","QVT", "EBTCOLD","BKB","EXN","TGT","ATS","BMT","CNX","ATB","ODN"
    ,"BTM","B2X","ATM","LIFE","DRT","STU","SMART","CL","LA","CLD"
    ,"ELM","HGT","POLL","SCL","ATL","EBTC","ETP","OTX","CDX","DRPU","HAC","CTX","ELE","SISA"
    ,"INDI","BTX","ITS","AMM","DBIX","PRE","KBR","TBT","ERO","SMS","ZAP","DOV","FRD","OTN","SPF"
    ,"SBTC","BTCA","WRC","LOC","SWFTC","STAR","DIM","NGC","ECH","CPAY","DATA"
    ,"UTT","EKO","TIO","WAX","ULTC","EET","C20","IDH","IPL","COV","SENT","SMT","W3C","CAS"
    ,"GRMD","AVH","TRAC","JNT","PCL","CLOUT","UTK","GNX","CHSB","NEU","TAU","MEK","BAR","FLP","R","PKT","WLK","EVN","CPG","BPTN","BETR"
    ,"ARCT","DBET","RNTB","HAND","BEZ","ACO","CTE","UTNP"
    ,"CPY","CHP","ACT","HIRE","SIG","RPM","MTX","BGG","SETH","WIZ","DADI","BDG","DATX","TRUE","DRG","BANCA","AUTO","NOAH","SOC","WILD"
    ,"INSUR","OCN","STQ","CVH","IFT","CGC","WAN","QLC","SYS","WPR","GRS","CLOAK","GNT","LOOM","BCN","BIFI","DBC","SRN","TOPC"
    ,"MDS","DAT","MEET","BCX","HT","PROPY","LET","EDU","ELA"
    ,"QUN","CTXC","ABT","AIDOC","THETA","ZLA","NAS","YEE","STK","QASH","RUFF"
    ,"MTN","DTA","BFT","ITC","WICC","REP","TUSD","ZEN","SKY","IOTX","QKC","AGI","NXS","ZB","QC"
    ,'UBTC','INK','TV','BTH','LBTC','HLC','BCW','BTP'
    ,'BITCNY','ENT','SAFE','BTN','CDC','DDM','BITE','HOTC'
    ,'EPC','BDS','GRAM','HPY','MITH','EOSDAC','KAN',"NPXS","SUNC"
    ,"ADH","AXP","BERRY","BSTN","DAXT","BMH","BUBO"
    ,"CAPP","DAY","CLR","WEALTH","CRPT","CVT","DAN","XDNICCO"
    ,"ERT","FOTA","WTT","GBX","HRB","HDG","HLW","HQX"
    ,"IHT","IML","MPK","KIN","LDC","XLC","LNC","MRV","MESH","MLD","XMO","NCT"
    ,"PQT","PBKX","PREMINE","ROOTS","GRPH","SHIP","CRS","SCC"
    ,"TEL","8BT","TFL","UGT","UNC","VIT","YCC","BBC","GET","TKY","ACAT","TCN","VIO","WIKI"
    ,"CVCOIN","FTX","FREC","NAVI","VME","BTCP"
    ,"LND","CSM","NANJ","MTC","NTK","AUC","CMCT"
    ,"MAN","TKA","PNT","FXT","NEXO","CHX","PAT","XMC"
    ,"EJOY","TBAR","HERO","STAK","FDZ","SPD","LUC","MITX"
    ,"TIV","B2G","LATX","ZPT","HBZ","FACE","MORPH","EBKC","CPT","WITH"
    ,"HTML","JOT","JBC","BNK","CBC","COIN","PMNT","ABYSS","BCI"
    ,"PITCH","TDS","DPN","UUU","KBC","BTV","XBP","CLN"
    ,"IVY","TTU","DOR","SPC","KEY",'OKB',"MFT",
    ,'AAC','ACE','BEC','BKX','CAG','CAI','CAN','CBT','CIC','DCR','DNA','DPY','EGT', 'FAIR','GSC','GTC'
    ,'HMC','HOT','INT','IPC','KCASH','LBA','LEV','LIGHT','MAG'
    ,'MDT','MKR','MOF','MOT','MVP','OF','OK06ETT','ORS','PRA','PST','RCT', 'READ','REF','REN','RFR','RNT', 'SHOW','SSC','STC','TCT','TRA'
    , 'TRIO','UCT','UGC','UKG','VEE','VIU', 'WFEE','WIN','XAS','YOU'
    ,'ZIP','HPB','CIT','HYC','SDA','TESTA','TESTB','TESTC'
    ,'BT2', 'KRM', 'LCC', 'ELEC', 'QNTU','CENNZ', 'SWM', 'CLO', 'MXM', 'DAI', 'DWS', 'PROC', 'BIT', 'REX', 'COSM', 'DCNT', 'EURS', 'MNX', 'WBTC'
    ,'ZCO','BIX','BTO','SNOV','BLT','SXUT','CZR','TNC','CPC','FSN','BBN','MED','DXT','LGO','NPER','IPSX','BOT','MT'
    ,'LKN','INSTAR','RED','PAI','CWV','BCV','HDAC','BOE','AT','UPP','SGC','HER','DCC','RTE','TTC','CAR','BZNT','BU'
    ,'AC3','TTT','XNK'];
  const api = new biboxApi('','');
  api.fetchSymbols((error,data)=>{
    if (!error) {
      const unknowCurrencies = [];
      for (let detail of data.result) {
        const symbol = detail.pair;
        const currencies = symbol.split("_");
        const midCurrency = currencies[0].toUpperCase();
        const baseCurrency = currencies[1].toUpperCase();
        if (!currentArray.includes(midCurrency) && !unknowCurrencies.includes(midCurrency)) {
          console.log(`CNY_${midCurrency} = '${midCurrency}'`);
          unknowCurrencies.push(midCurrency)
          // console.log(`(CNY_${midCurrency}, CNY_${midCurrency})`);
        }
        if (!currentArray.includes(baseCurrency) && !unknowCurrencies.includes(baseCurrency)) {
          console.log(`CNY_${baseCurrency} = '${baseCurrency}'`);
          unknowCurrencies.push(baseCurrency);
          // console.log(`(CNY_${baseCurrency}, CNY_${baseCurrency})`);
        }
      }
      console.log("========================")
      unknowCurrencies.map((item) => console.log(`(CNY_${item}, CNY_${item}),`))
    }
  })
}
// printCurrency()

function testOrder(){
  const order = new Order();
  order.order("BTC_USDT","0.01","0.01",constants.OrderSideBuy,(error,result)=>{
    console.log(error);
    console.log(result);
  })
  // api.balance((error,data)=>{
  //   console.log(error);
  //   console.log(data);
  // })
  // api.getTrades("BTC_USDT",(error,data)=>{
  //   console.log(error);
  //   console.log(data);
  // })
  // const api = new biboxApi();
  // api.fetchHistorOrders(1,20,"BU_ETH",constants.OrderSideSell,(error,result)=>{
  //   console.log(error);
  //   console.log(result);
  // })
  // api.searchOrder('873502366',(error,result)=>{
  //   console.log(result);
  // })
}
// testOrder();
// const amount = (0.0917 * parseFloat(0.00001005)).toFixed(10);
// console.log(amount);

// function testEmail(){
//   const sendEmail = require('./mailer');
//   sendEmail("测试邮件邮件","lalalalalalalal");
// }

// testEmail();

function test() {
  const api = new biboxApi();
  api.fetchSymbols((error,result)=>{
    console.log(error);
    console.log(result);
  })
}

// test()