const constants = require('./constants');
const biboxApi = require('./api');

const StateFilled = 3;
const StateNew = 1;
const StatePartiallyFilled = 2;
const StatePartiallyCancelled = 4;
const StateCancelled = 5;
const StateCancelling = 6;

function returnFakeOrder(symbol, price, amount) {
  return {
    orderId: "testOrder",
    price: price,
    status: constants.OrderStatusCanceled,
    transactTime: Date.now(),
    origQty: amount,
    executedQty: 0,
    symbol: symbol,
  }
}

function convertToRecordOrder(order) {
  let status;
  switch (order.status) {
    case StateFilled:
    case StatePartiallyCancelled:
      status = constants.OrderStatusFilled;
      break;
    case StateCancelled:
      status = constants.OrderStatusCanceled;
      break;
    case StateNew:
      status = constants.OrderStatusNew;
      break;
    case StatePartiallyFilled:
      status = constants.OrderStatusPartiallyFilled;
      break;
    case StateCancelling:
      status = constants.OrderStatusPendingCancel;
      break;
  }
  return {
    orderId: order.id + '',
    price: order.price,
    status: status,
    transactTime: order.createdAt,
    origQty: order.amount,
    executedQty: order.deal_amount,
    symbol: order.pair,
    type: order.order_side,
  }
}

function isTimeOutError(error){
  return error.code === 'ESOCKETTIMEDOUT' || error.code === 'ETIMEDOUT';
}

class Order {
  constructor() {
    this.api = new biboxApi();
  }

  _handleFOKSearchResult(orderId, finalCallback, error, result) {
    if (error) {
      console.error("搜索订单出错");
      console.error(error);
      let timeout = 100;
      if(error.code == '2091' || error.code == '4003'){
        console.log("2秒后再继续搜索");
        timeout = 2000;
      }
      setTimeout(() => {
        this.api.searchOrder(orderId, this._handleFOKSearchResult.bind(this, orderId, finalCallback));
      }, timeout);
      return;
    }
    const order = result.result;
    if(!order.amount && !order.deal_amount){
      console.error("没有返回amount 和deal amount字段，继续搜索");
      this.api.searchOrder(orderId, this._handleFOKSearchResult.bind(this, orderId, finalCallback));
    }else if (order.status === StateFilled || order.status === StateCancelled || order.status === StatePartiallyCancelled) {
      finalCallback(null, convertToRecordOrder(order));
    } else if (order.status === StateNew || order.status === StatePartiallyFilled) {
      this.api.cancelOrder(orderId, (error, result) => {
        // setTimeout(() => {
        console.log("尝试取消，准备搜索订单");
          this.api.searchOrder(orderId, this._handleFOKSearchResult.bind(this, orderId, finalCallback));
        // }, 80)
      })
    } else {
      setTimeout(() => {
      console.log("订单尚未完成或取消，再次搜索");
        this.api.searchOrder(orderId, this._handleFOKSearchResult.bind(this, orderId, finalCallback));
      }, 500);
    }
  }

  FOKLikeOrder(symbol, price, amount, side, callback) {
    if (!constants.RealOrder) {
      callback(null, returnFakeOrder(symbol, price, amount));
      return;
    }
    this.api.order(price, amount, symbol, side, (error, result) => {
      if (error) {
        callback(error, null);
        return;
      }
      const orderId = result.result;
      setTimeout(()=>{
        this.api.searchOrder(orderId, this._handleFOKSearchResult.bind(this, orderId, callback));
      },50);
    })
  }

  order(symbol, price, amount, side, callback,mustSuccess = false) {
    if (!constants.RealOrder) {
      callback(null, returnFakeOrder(symbol, price, amount));
      return;
    }
    this.api.order(price, amount, symbol, side, (error, result) => {
      if (error) {
        callback(error, null);
        return;
      }
      const orderId = result.result;
      const api2 = this.api;

      function handleSearchResult(error, result) {
        if (error) {
          console.error("搜索订单出错");
          console.error(error);
          let timeout = 100;
          if(error.code == '2091' || error.code == '4003'){
            console.log("2秒后再继续搜索");
            timeout = 2000;
          }
          setTimeout(() => {
            this.api.searchOrder(orderId, this._handleFOKSearchResult.bind(this, orderId, finalCallback));
          }, timeout);
        }
        if(!result.result.amount){
          console.error("没有返回amount，再次搜索");
          api2.searchOrder(orderId, handleSearchResult.bind(this));
          return;
        }
        callback(null, convertToRecordOrder(result.result));
      }

      this.api.searchOrder(orderId, handleSearchResult.bind(this));
    })
  }
}

module.exports = Order;