const os = require('os');


function getLocalIpv4s() {
  var ifaces = os.networkInterfaces();
  var ips = [];
  var func = function(details) {
    if (details.family === 'IPv6' || details.internal) {
      return;
    }
    ips.push(details.address);
  };
  for (var dev in ifaces) {
    ifaces[dev].forEach(func);
  }
  return ips;
};

const ips = getLocalIpv4s();


function mergeDepth(oldDepth, updateDepth, isAsk) {
  if(!updateDepth.length){
    return oldDepth;
  }
  var i = []
    , r = {
    a: 0,
    b: 0
  };
  if (isAsk)
    for (; r.a < oldDepth.length || r.b < updateDepth.length;)
      void 0 === oldDepth[r.a] ? i.push(updateDepth[r.b++]) : void 0 === updateDepth[r.b] ? i.push(oldDepth[r.a++]) : parseFloat(oldDepth[r.a][0]) > parseFloat(updateDepth[r.b][0]) ? i.push(updateDepth[r.b++]) : oldDepth[r.a][0] == updateDepth[r.b][0] ? (parseFloat(updateDepth[r.b][1]) > 1e-8 ? i.push(updateDepth[r.b++]) : r.b++,
        r.a++) : i.push(oldDepth[r.a++]);
  else
    for (; r.a < oldDepth.length || r.b < updateDepth.length;)
      void 0 === oldDepth[r.a] ? i.push(updateDepth[r.b++]) : void 0 === updateDepth[r.b] ? i.push(oldDepth[r.a++]) : parseFloat(oldDepth[r.a][0]) < parseFloat(updateDepth[r.b][0]) ? i.push(updateDepth[r.b++]) : oldDepth[r.a][0] == updateDepth[r.b][0] ? (parseFloat(updateDepth[r.b][1]) > 1e-8 ? i.push(updateDepth[r.b++]) : r.b++,
        r.a++) : i.push(oldDepth[r.a++]);
  return i
}

function mergeDepthAsk(oldDepth, updateDepth,oldVersion) {
  const results = [];
  const cal = {old: 0, updated: 0};
  for (; cal.old < oldDepth.length || cal.updated < updateDepth.length;) {
    if (oldDepth[cal.old] === undefined) {
      updateDepth[cal.updated].size > 1e-8 && results.push(updateDepth[cal.updated]);
      cal.updated++;
    } else if (updateDepth[cal.updated] === undefined) {
      results.push(oldDepth[cal.old]);
      cal.old++;
    } else if (parseFloat(oldDepth[cal.old].price) > parseFloat(updateDepth[cal.updated].price)) {
      updateDepth[cal.updated].size > 1e-8 && results.push(updateDepth[cal.updated]);
      cal.updated++;
    } else if (parseFloat(oldDepth[cal.old].price) === parseFloat(updateDepth[cal.updated].price)) {
      if (parseFloat(updateDepth[cal.updated].size) > 1e-8) {
        results.push(updateDepth[cal.updated]);
      }
      cal.updated++;
      cal.old++;
    } else {
      results.push(oldDepth[cal.old]);
      cal.old++;
    }
  }
  return results
}

function mergeDepthBids(oldDepth, updateDepth, oldVersion) {
  const result = [];
  const cal = {old: 0, updated: 0};
  for (; cal.old < oldDepth.length || cal.updated < updateDepth.length;) {
    if (oldDepth[cal.old] === undefined) {
      updateDepth[cal.updated].size > 1e-8 && result.push(updateDepth[cal.updated]);
      cal.updated++;
    } else if (updateDepth[cal.updated] === undefined) {
      result.push(oldDepth[cal.old]);
      cal.old++;
    } else if (parseFloat(oldDepth[cal.old].price) < parseFloat(updateDepth[cal.updated].price)) {
      updateDepth[cal.updated].size > 1e-8 && result.push(updateDepth[cal.updated]);
      cal.updated++;
    } else if (parseFloat(oldDepth[cal.old].price) === parseFloat(updateDepth[cal.updated].price)) {
      if (parseFloat(updateDepth[cal.updated].size) > 1e-8) {
        result.push(updateDepth[cal.updated++]);
        cal.old++;
      } else {
        cal.updated++;
        cal.old++;
      }
    } else {
      result.push(oldDepth[cal.old++])
    }
  }
  return result;
}



module.exports = {
  IPs: ips,
  mergeDepthBids:mergeDepthBids,
  mergeDepthAsk:mergeDepthAsk,
  mergeDepth:mergeDepth
}