const os = require('os');


function getLocalIpv4s() {
  var ifaces = os.networkInterfaces();
  var ips = [];
  var func = function(details) {
    if (details.family === 'IPv6' || details.internal) {
      return;
    }
    ips.push(details.address);
  };
  for (var dev in ifaces) {
    ifaces[dev].forEach(func);
  }
  return ips;
};

const ips = getLocalIpv4s();


function mergeDepth(oldDepth, updateDepth, isAsk) {
  var i = []
    , r = {
    a: 0,
    b: 0
  };
  if (isAsk)
    for (; r.a < oldDepth.length || r.b < updateDepth.length;)
      void 0 === oldDepth[r.a] ? i.push(updateDepth[r.b++]) : void 0 === updateDepth[r.b] ? i.push(oldDepth[r.a++]) : parseFloat(oldDepth[r.a][0]) > parseFloat(updateDepth[r.b][0]) ? i.push(updateDepth[r.b++]) : oldDepth[r.a][0] == updateDepth[r.b][0] ? (parseFloat(updateDepth[r.b][1]) > 1e-8 ? i.push(updateDepth[r.b++]) : r.b++,
        r.a++) : i.push(oldDepth[r.a++]);
  else
    for (; r.a < oldDepth.length || r.b < updateDepth.length;)
      void 0 === oldDepth[r.a] ? i.push(updateDepth[r.b++]) : void 0 === updateDepth[r.b] ? i.push(oldDepth[r.a++]) : parseFloat(oldDepth[r.a][0]) < parseFloat(updateDepth[r.b][0]) ? i.push(updateDepth[r.b++]) : oldDepth[r.a][0] == updateDepth[r.b][0] ? (parseFloat(updateDepth[r.b][1]) > 1e-8 ? i.push(updateDepth[r.b++]) : r.b++,
        r.a++) : i.push(oldDepth[r.a++]);
  return i
}


module.exports = {
  IPs: ips,
  mergeDepth: mergeDepth
}