const Strategy3 = require('./strategy3');
const machine = process.env['MACHINE'];
const Order = require('./order_kucoin');
const constants = require('./constants');
const STRATEGY3_RETURN_MIN_AMOUNT_MAP = {
  USDT: 20,
  BTC: 0.002,
  ETH: 0.03,
  NEO: 1,
  KCS: 20,
};

class BiboxStrategy3 extends Strategy3 {
  constructor(collector) {
    super(collector, machine);
    this.orderService = new Order();
    this.maxAllowLoss = 20;
    // this.lastPrice = -1;
    // this.samePriceCount = 0;
  }

  _doTrade(baseCurrency1, midCurrency, baseCurrency2, buyPrice, sellPrice, returnPrice, amount, returnAmount, doSaveOrder) {
    return;
    const buySymbol = this.collector.getSymbol(baseCurrency1, midCurrency);
    const buyStartTime = Date.now();
    const collector = this.collector;
    const orderService = this.orderService;
    const sellSymbol = this.collector.getSymbol(midCurrency, baseCurrency2);
    const returnSymbol = this.collector.getSymbol(baseCurrency2, baseCurrency1);
    let createdSellOrder = false;
    let createdBuyOrder = false;
    let retryTime = 8;
    const totalRetryTime = retryTime;

    function sellOrder() {
      console.log("sell@" + sellSymbol + " amount:" + amount + " price:" + sellPrice);
      const sellStartTime = Date.now();
      orderService.order(
          sellSymbol, sellPrice, amount, constants.OrderSideSell, constants.TimeInForceGTC
          , (error, order) => {
            if (error) {
              if (error.code === "NO_BALANCE" || (error.code === 'ERROR' && error.msg === 'SYMBOL NOT FOUND') || error.statusCode == 502 || error.code == 'ECONNRESET') {
                if (retryTime > 0 && !createdSellOrder) {
                  console.log("提示余额不足，再次尝试");
                  retryTime--;
                  setTimeout(() => {
                    sellOrder();
                  }, (totalRetryTime - retryTime) * 50);
                } else if (!createdSellOrder && createdBuyOrder) {
                  console.log("已没有重试次数，但是买单已创建成功，继续重试");
                  setTimeout(() => {
                    sellOrder();
                  }, 500);
                }
              }
              console.error("sell error:" + JSON.stringify(error) + ";sell price:" + sellPrice + " @amount:" + amount);
              return;
            }
            createdSellOrder = true;
            doSaveOrder(order, midCurrency, baseCurrency2, constants.OrderTypeSell);
            console.log("sell start@" + sellStartTime + " end@" + Date.now() + " symbol:" + sellSymbol);
          })
    }

    function returnOrder() {
      console.log("return@" + returnSymbol + " amount:" + returnAmount + " price:" + returnPrice);
      const returnStartTime = Date.now();
      orderService.order(returnSymbol, returnPrice, returnAmount, collector.getTradeSide(baseCurrency2, baseCurrency1), constants.TimeInForceGTC
          , (error, order) => {
            if (error) {
              console.error("return error:");
              console.error(error);
              return;
            }
            console.log("return start@" + returnStartTime + " end@" + Date.now() + " symbol:" + returnSymbol);
            doSaveOrder(order, baseCurrency2, baseCurrency1, constants.OrderTypeReturn);
          }, true);
    }

    console.log("buy@" + buySymbol + " amount:" + amount + " price:" + buyPrice);
    orderService.order(buySymbol, buyPrice, amount, constants.OrderSideBuy, constants.TimeInForceFOK
        , (error, order) => {
          if (error) {
            console.error("buy error:");
            console.error(error);
            return;
          }
          console.log("buy start@" + buyStartTime + " end@" + Date.now() + " symbol:" + buySymbol);
          if (order.executedQty === order.origQty) {
            console.log("买入全部成交");
            createdBuyOrder = true;
            // amount = collector.processAmount(midCurrency, baseCurrency2, parseFloat(order.executedQty * 0.999));
            // setTimeout(() => {
              sellOrder();
            // }, 120);
            returnOrder();
          } else if (parseFloat(order.executedQty) > 0) {
            returnAmount = parseFloat(returnAmount) * parseFloat(order.executedQty) / parseFloat(amount);
            returnAmount = collector.processAmount(baseCurrency2, baseCurrency1, returnAmount);
            amount = collector.processAmount(midCurrency, baseCurrency2, order.executedQty);
            console.log(`买入部分成交${order.executedQty} 回归量调整为${returnAmount}`);
            createdBuyOrder = true;
            if (parseFloat(amount) > 0)
              // setTimeout(() => {
                sellOrder();
              // }, 120);
            if (parseFloat(returnAmount) > 0)
              returnOrder();
            else {
              console.log("回归数量太小，不执行回归");
            }
          } else {
            console.warn("买入失败");
            retryTime = 0;
          }
          doSaveOrder(order, baseCurrency1, midCurrency, constants.OrderTypeBuy);
        })

    // if(!this.collector.isBaseCurrency(midCurrency) && this.collector.getCurrencyBalance(midCurrency,true) < amount){
    //   for(let i=0;i<2;i++){
    //     setTimeout(()=>{
    //       sellOrder();
    //     },i*200+100);
    //   }
    // }
  }

  _isFeeDeducedByOther() {
    return false;
  }

  _getTrades(order, callback) {
    callback([]);
  }

  _getMinReturnAmount(currency) {
    return STRATEGY3_RETURN_MIN_AMOUNT_MAP[currency] || 1;
  }

  _getMinTradeInterval() {
    return 15000;
  }

  _getMinMargin() {
    return 0.08;
  }
  // _giveUpOrder(baseCurrency1, midCurrency, baseCurrency2, totalMarginRate, buyDepth, sellDepth) {
  //   if (sellDepth === 1) {
  //     const sellPrices = this.collector.getDepth(midCurrency, baseCurrency2, 2);
  //     const possibleLoss = (sellPrices[0][0] - sellPrices[1][0]) / sellPrices[0][0];
  //     // if(sellPrices[0][0] === this.lastPrice){
  //     //   this.samePriceCount ++;
  //     // }else{
  //     //   this.lastPrice = sellPrices[0][0];
  //     //   this.samePriceCount = 0;
  //     // }
  //     const possibleLossMoney = (possibleLoss - totalMarginRate / 100) * sellPrices[1][0];
  //     if (possibleLossMoney > this.maxAllowLoss) {
  //       console.log(`此单风险过高，放弃。可能损失：${possibleLossMoney},${baseCurrency1}=>${midCurrency}=>${baseCurrency2}`);
  //       return true;
  //     }
  //     // if(possibleLoss*100-totalMarginRate > 3){
  //     //   console.log(`此单风险过高，放弃。买一：${sellPrices[0][0]},买二：${sellPrices[1][0]},损失率${(possibleLoss * 100).toFixed(4)}，利差：${totalMarginRate.toFixed(4)}`);
  //     //   return true;
  //     // }
  //   }
  //   return super._giveUpOrder(baseCurrency1, midCurrency, baseCurrency2, totalMarginRate, buyDepth, sellDepth);
  // }
  _logDelay() {
    return true;
  }

  _needConsiderDepthCount() {
    return [[2, 1], [6,5,3], [2, 1]];
  }

  // _giveUpOrder(baseCurrency1, midCurrency, baseCurrency2,totalMarginRate,buyDepth,sellDepth){
  //   return false
  // }

}


const BiboxCollector = require('./kucoinCollector');
const collector = new BiboxCollector(null);
collector.runStrategy3();
const strategy3 = new BiboxStrategy3(collector);
strategy3.run();

