"""
Provides a set of pluggable permission policies.
"""
from __future__ import unicode_literals, absolute_import

from rest_framework.permissions import BasePermission


class IsAuthUser(BasePermission):
    """
    Allows access only to auth users.
    """

    def has_permission(self, request, view):
        user = request.user
        return user.is_authenticated


class IsProfileUser(BasePermission):
    """
    Allows access only to customer users.
    """

    def has_permission(self, request, view):
        user = request.user
        return user.is_authenticated and getattr(user, 'profile', None)


class IsManager(BasePermission):
    """
    Allows access only to managers.
    """

    def has_permission(self, request, view):
        user = request.user
        if user.is_superuser:
            return True
        manager = getattr(user, 'manager', None)
        if user.is_authenticated and manager:
            return True
        return False


class IsAuthManager(BasePermission):
    """
    Allows access only to managers.
    """

    def has_permission(self, request, view):
        user = request.user
        if user.is_superuser:
            return True
        manager = getattr(user, 'manager', None)
        if user.is_authenticated and manager:
            path = request.path
            if path in manager.rules:
                return True
        return False
