# coding=utf8
from __future__ import absolute_import

from django.db.models.query_utils import Q
from rest_framework.response import Response
from core.framework.manageviews import TemplateHTMLRendererView, \
    ManageResponseViewSet, ManageListView, ManageAddView, \
    ManageEditView, ManageActiveView, ManageDeleteView
from core.framework.permissions import IsAuthManager
from core.framework.pagination import ManagePagination

from apps.base.models import Contacts
from apps.base.filters import ManageContactsFilter
from apps.manage.apps.contacts.serializers import ManageContactsSerializer


class ManageContactsView(TemplateHTMLRendererView):
    template_name = 'manage/apps/contacts/index.html'
    permission_classes = [IsAuthManager]

    def get(self, request):
        manage = {
            'filter': ManageContactsFilter,
            'actions': [{'id': 'add', 'text': '新建'}],
        }
        serializer = ManageContactsSerializer()
        return Response({'add_serializer': serializer,
                         'edit_serializer': serializer,
                         'manage': manage})


class ManageContactsAPIViewSet(ManageListView, ManageAddView,
                              ManageEditView, ManageActiveView, ManageDeleteView,
                              ManageResponseViewSet):
    model = Contacts
    filter_cls = ManageContactsFilter
    queryset = Contacts.objects.all()
    permission_classes = [IsAuthManager]
    serializer_class = ManageContactsSerializer
    pagination_class = ManagePagination
