# coding=utf8

from rest_framework.exceptions import APIException
from .errcode import ERR_MSG


class CustomAPIException(APIException):
    errcode = -1

    def __init__(self, errcode=-1, errmsg=''):
        self.errcode = errcode
        self.errmsg = errmsg

    def __str__(self):
        return ERR_MSG.get(self.errcode, self.errmsg)


class ManageAPIException(APIException):
    errcode = -9

    def __init__(self, errcode=-9, errmsg=''):
        self.errcode = errcode
        self.errmsg = errmsg

    def __str__(self):
        return ERR_MSG.get(self.errcode, self.errmsg)
