from django.db import models
from core.utils.functions import gen_random_str


class UnDeleteManager(models.Manager):
    def get_queryset(self):
        return super(UnDeleteManager, self).get_queryset().filter(deleted=False)


class BaseModel(models.Model):
    created_at = models.DateTimeField(auto_now_add=True, verbose_name='创建时间')
    updated_at = models.DateTimeField(auto_now=True, verbose_name='修改时间')
    deleted = models.BooleanField(default=False)
    active = models.BooleanField(default=True)
    objects = UnDeleteManager()

    class Meta:
        ordering = ['-id']
        abstract = True

    @classmethod
    def gen_unique_id(cls, prefix=None, length=8):
        return '{}{}'.format((prefix if prefix else ''), gen_random_str(length=length))

    @property
    def get_active_display(self):
        return '正常' if self.active else '禁用'