# coding=utf8
from __future__ import absolute_import, unicode_literals

from rest_framework import serializers
from apps.base.models import Contacts


class ManageContactsSerializer(serializers.ModelSerializer):
    class Meta:
        model = Contacts
        fields = ('id', 'name', 'email')
        read_only_fields = ['id']

    def validate(self, attrs):
        return attrs

    def to_representation(self, instance):
        result = serializers.ModelSerializer.to_representation(self, instance)
        return result
