# coding=utf8
from __future__ import unicode_literals

import cgi
import json
from django.core.serializers.json import DjangoJSONEncoder
from rest_framework.response import Response
from . import errcode as err_code


class APIResponse(Response):
    """
    An HttpResponse that allows its data to be rendered into
    arbitrary media types.
    """

    def __init__(self, errcode=err_code.ERRCODE_SUCCESS, errmsg='', detail='', data={}, status=None,
                 template_name=None, headers=None,
                 exception=False, content_type=None):
        if not errmsg:
            errmsg = err_code.ERR_MSG.get(errcode, u'未知错误')
        res_data = {'errcode': errcode, 'errmsg': errmsg, 'data': data, 'detail': detail}
        super(APIResponse, self).__init__(data=res_data, status=status, template_name=template_name,
                                          headers=headers, exception=exception, content_type=content_type)


class MangeAPIResponse(Response):
    """
    An HttpResponse that allows its data to be rendered into
    arbitrary media types.
    """

    def __init__(self, errcode=err_code.ERRCODE_SUCCESS, errmsg='', detail='', data={}, status=None,
                 template_name=None, headers=None,
                 exception=False, content_type=None):
        if not errmsg:
            errmsg = err_code.ERR_MSG.get(errcode, u'未知错误')
        # data = json.dumps(data, cls=DjangoJSONEncoder)
        # data = json.loads(cgi.escape(data))
        res_data = {'errcode': errcode, 'errmsg': errmsg, 'data': data, 'detail': detail}
        super(MangeAPIResponse, self).__init__(data=res_data, status=status, template_name=template_name,
                                               headers=headers, exception=exception, content_type=content_type)
