/**
 * Created by jun on 2017/5/7.
 */

$.extend($.fn.validatebox.defaults.rules, {
    bank: {
		validator: function(value, param){
		    var reg = /^([1-9]{1})(\d{15}|\d{18})$/;
			return reg.test(value);
		},
		message: '请输入正确的银行卡号'
    },
    number: {
		validator: function(value, param){
		    var reg = /^\+?[0-9]*$/;
			return reg.test(value);
		},
		message: '请输入正确的正整数'
    },
    float: {
		validator: function(value, param){
		    var reg = /(^[1-9]([0-9]+)?(\.[0-9]{1,2})?$)|(^(0){1}$)|(^[0-9]\.[0-9]([0-9])?$)/;
			return reg.test(value);
		},
		message: '请输入正确的两位小数'
    },
    money: {
		validator: function(value, param){
		    var reg = /(^[1-9]([0-9]+)?(\.[0-9]{1,2})?$)|(^(0){1}$)|(^[0-9]\.[0-9]([0-9])?$)/;
			return reg.test(value);
		},
		message: '请输入正确的金额'
    },
    mobile: {
		validator: function(value, param){
		    var reg = /^1[34578]\d{9}$/;
			return reg.test(value);
		},
		message: '请输入正确的手机号码'
    },
    email: {
		validator: function(value, param){
		    var reg = /^([a-zA-Z0-9_-])+@([a-zA-Z0-9_-])+(.[a-zA-Z0-9_-])+/;
			return reg.test(value);
		},
		message: '请输入正确的邮箱地址'
    }
});
