/**
 * Created by jun on 2017/08/22.
 */

var renderTable = function (opts) {
    var table = {
        tableId: undefined,
        table: undefined,
        editIndex: undefined,
        isEdited: false,
        opts: {
            width: '100%',
            tableId: '#mTable',
            toolbar: '#toolbar',
            searchBtn: '#searchBtn',
            searchForm: '#searchForm',
            exportBtn: '#exportBtn',
            editable: false,
            loadMsg: false,
            singleSelect: true,
            rownumbers: true,
            showFooter: true,
            fitColumns: true,
            pagination: true,
            pageSize: 20,
            pageList: [20, 50, 100],
            columns: [[]],
            data: [],
        },
        init: function (opts) {
            var self = this;
            $.extend(self.opts, opts);
            var _opts = {
                height: $(window).height() - (self.opts.subHeight || 25),
                loader: function (params, success, error) {
                    if (self.opts.url) {
                        if (self.opts.searchForm) {
                            var searchParams = $(self.opts.searchForm).serializeArray();
                            for (var i = 0; i < searchParams.length; i++) {
                                if (searchParams[i].value.trim() != "") {
                                    params[searchParams[i].name] = searchParams[i].value;
                                }
                            }
                        }
                        if (self.opts.defaultParams) {
                            params = $.extend(param, self.opts.defaultParams);
                        }
                        params['page_size'] = params.rows;
                        get(self.opts.url, params, function (result) {
                            if (result.errcode == 200) {
                                if (!self.opts.loadCallBack) {
                                    return success(result.data);
                                }
                                return self.opts.loadCallBack(result, success);
                            } else {
                                showMsg(result.errmsg);
                                error();
                            }
                        });
                    } else {
                        return false;
                    }
                },
                loadFilter: function (data) {
                    if (data) {
                        return {"total": data.total || 0, "rows": data.rows || data.results || []};
                    }
                    return false;
                },
                onLoadSuccess: function (data) {
                    if (data.total == 0) {
                        var body = $(this).data().datagrid.dc.body2;
                        body.find('table tbody').append('<tr><td colspan="100"' +
                            ' style="height: 60px; border: none; font-size: 16px; color: #333;">' +
                            '<p style=" display: flex; align-items: center;justify-content: center; width: 200px;margin: 0 auto;">' +
                            '<i class="icon icon-i"></i><span style="margin-left: 8px;">查询无相关条件的记录</span></p></td></tr>');
                    }
                    if (data.values) {
                        for (var v in data.values) {
                            $(v).text(values[v])
                        }
                    }
                },
                onSelectPage: function (pageNumber, pageSize) {
                    getData(pageNumber, pageSize);
                },
                onBeforeEdit: self.opts.onBeforeEdit || function (index, field) {
                    self.editIndex = index;
                },
            };
            $.extend(self.opts, _opts);
            self.tableId = self.opts.tableId;
            if (self.opts.editable) {
                self.table = $(self.tableId).edatagrid(self.opts);
            } else {
                self.table = $(self.tableId).datagrid(self.opts);
            }
            if (self.opts.searchBtn) {
                $(self.opts.searchBtn).bind("click", function (e) {
                    e.preventDefault();
                    self.table.datagrid("load");
                });
            }
            if (self.opts.exportBtn && self.opts.exportUrl) {
                $(self.opts.exportBtn).bind("click", function (e) {
                    var searchParams = '';
                    if (self.opts.searchForm) {
                        searchParams = $(self.opts.searchForm).serialize();
                    }
                    if (self.opts.exportUrl) {
                        $(self.opts.exportBtn).attr('href', self.opts.exportUrl + '?' + searchParams);
                    }
                });
            }
            if (!self.opts.noResize) {
                $(window).resize(function () {
                    $(self.tableId).datagrid('resize', {height: $(window).height() - (self.opts.subHeight || 25)});
                });
            }
            return self;
        },
        endEditing: function () {
            if (this.editIndex == undefined) {
                return true
            }
            //校验指定的行，如果有效返回true
            if ($(this.tableId).datagrid('validateRow', this.editIndex)) {
                $(this.tableId).datagrid('endEdit', this.editIndex); //结束编辑
                this.editIndex = undefined;
                this.isEdited = true;
                return true;
            } else {
                return false;
            }
        }
    }
    return table.init(opts);
};