# coding=utf8
import copy

Rules = [
    {
        'id': 'task',
        'icon_cls': 'fa fa-bell-o',
        'text': '提醒任务',
        'is_pNode': True,
    },
    {
        'id': 'contacts',
        'icon_cls': 'fa fa-address-card-o',
        'text': '通讯录',
        'is_pNode': True,
    },
]


def get_rules(rules=None):
    self_rules = [str(x) for x in rules] if rules else []

    def _get_rules(children):
        for child in children:
            if child.get('children'):
                child['children'] = _get_rules(child.get('children'))
            else:
                if child.get('id') in self_rules:
                    child['checked'] = True
                    continue
        return children

    _rules = rules if rules else copy.deepcopy(Rules)
    return _get_rules(_rules)


def get_shop_rules(rules):
    ids = []
    for rule in rules:
        if rule.get('id') in ['/manage/shop/', '/manage/base/car_brand/', '/manage/base/car_model/',
                              '/manage/schedule/']:
            continue
        ids.append(rule.get('id'))
        if rule.get('children'):
            ids += get_shop_rules(rule.get('children'))
    return ids
