/**
 * Created by jun on 2017/8/24.
 */
//自动消失的提示
function showMsg(msg, interval, error) {
    var $pop = $("#m-pop");
    if (error) {
        $pop = $("#m-pop-error");
    }
    if ($pop.is(":visible")) {
        clearTimeout(showMsg.timer);
    }
    $pop.children(".pop-msg").html(msg);
    $pop.css({"top": "0px"});
    showMsg.timer = setTimeout(function () {
        $pop.css("top", "-90px");
    }, interval || 2000);
};

function show_ajax_loading() {
    if (document.getElementById("page-loading").style.display == "none") {
        $(".ajax-loading").show();
    }
};

function hide_ajax_loading() {
    $(".ajax-loading").hide();
};

var ajax = function (url, type, params, dataType, callback, sync) {
    show_ajax_loading();
    $.ajax({
        url: url,
        data: params,
        type: type,
        dataType: dataType,
        async: !sync,
        success: function (response) {
            hide_ajax_loading();
            if (!(response instanceof Object)) {
                response = JSON.parse(response);
            }
            if (response.errcode == 200) {
                callback(response);
            } else {
                showMsg(response.errmsg, false, true);
            }
        },
        error: function (err) {
            hide_ajax_loading();
            showMsg('网络请求错误', false, true);
        }
    });
};
var get = function (url, params, callback) {
    ajax(url, 'GET', params, 'json', callback);
};
var getSync = function (url, params, callback) {
    ajax(url, 'GET', params, 'json', callback, true);
}
var post = function (url, params, callback) {
    ajax(url, 'POST', params, 'json', callback);
};
var postSync = function (url, params, callback) {
    ajax(url, 'POST', params, 'json', callback, true);
}

function getFormParams(formId) {
    var data = Object();
    var params = $(formId).serializeArray();
    for (var i = 0; i < params.length; i++) {
        if (params[i].value.trim() != "") {
            if (data[params[i].name]) {
                data[params[i].name] += '#' + params[i].value;
            } else {
                data[params[i].name] = params[i].value;
            }

        }
    }
    return data;
}

function myGetConfirm(title, message, url, callback) {
    $.messager.confirm(title, message, function (r) {
        if (r) {
            get(url, {}, function (response) {
                if (response.errcode == 200) {
                    showMsg('操作成功');
                    callback(response);
                } else {
                    showMsg(response.errmsg, 2000, true);
                }
            });
        }
    });
}
function myPostConfirm(title, message, url, data, callback) {
    $.messager.confirm(title, message, function (r) {
        if (r) {
            post(url, data, function (response) {
                if (response.errcode == 200) {
                    showMsg('操作成功');
                    callback(response);
                } else {
                    showMsg(response.errmsg, 2000, true);
                }
            });
        }
    });
}

$(document).on("click", ".page-refresh", function (e) {
    e.preventDefault();
    location.reload();
});


$(document).on("change", ".object-pic", function (e) {
    var $this = $(this);
    lrz(this.files[0], {width: 1500})
        .then(function (rst) {
            $this.prev('img').attr("src", rst.base64);
        })
        .catch(function (err) {
            // 处理失败会执行
            alert(err);
        })
        .always(function () {
            // 不管是成功失败，都会执行
        });
});

function ajax_save_form(form, callback) {
    show_ajax_loading();
    $(form).ajaxSubmit({
        data: {},
        dataType: 'json',
        success: function (response) {
            hide_ajax_loading();
            if (!(response instanceof Object)) {
                response = JSON.parse(response);
            }
            if (response.errcode == 200) {
                callback(response);
            } else {
                showMsg(response.errmsg, 2000, true);
            }
        }
    });
}