# coding=utf8
from collections import OrderedDict
from rest_framework.pagination import PageNumberPagination

from .response import APIResponse, MangeAPIResponse


class BasePageNumberPagination(PageNumberPagination):
    page_size = 25
    page_size_query_param = 'page_size'
    max_page_size = 100
    values = {}
    response = APIResponse

    def get_response(self):
        return self.response

    @classmethod
    def get_values(cls):
        return {}

    def get_paginated_response(self, data):
        return self.get_response()(data=OrderedDict([
            ('total', self.page.paginator.count),
            ('next', self.get_next_link()),
            ('has_next', True if self.get_next_link() else False),
            ('page', self.page.number),
            ('page_size', self.page_size),
            ('results', data),
            ('values', self.get_values()),
        ]))


class ManagePagination(BasePageNumberPagination):
    response = MangeAPIResponse
