# coding=utf8
from django_filters import CharFilter
from django.forms import TextInput
from core.orm.filter import BaseFilterSet
from apps.base.models import Contacts


class ManageContactsFilter(BaseFilterSet):
    search = CharFilter(method='filter_search', label='关键字', widget=TextInput(attrs={'placeholder': '',
                                                                                     'class': 'input-brand x2'}))

    class Meta:
        model = Contacts
        fields = []
        search_fields = ['name', ]
