# coding=utf8
from django.conf.urls import url, include
from apps.manage.views import ManageLogOutView, ManageResetPasswordView, \
    ManageHomeView, login, first_login, ManageResetPasswordAPIView, ManageRules, ManageDashboardView

urlpatterns = [
    url(r'^login/$', login, name='manage_login'),
    url(r'^first_login/$', first_login, name='manage_first_login'),
    url(r'^logout/$', ManageLogOutView.as_view(), name='manage_logout'),
    url(r'^reset_password_index/$', ManageResetPasswordView.as_view(), name='manage_reset_password_index'),
    url(r'^reset_password/$', ManageResetPasswordAPIView.as_view(), name='manage_reset_password'),
    url(r'^$', ManageHomeView.as_view(), name='manage_home'),
    url(r'^dashboard/$', ManageDashboardView.as_view(), name='manage_dashboard'),
    url(r'^rules/$', ManageRules.as_view(), name='manage_rules'),
]

urlpatterns += [
    url(r'', include('apps.manage.apps.task.urls')),
    url(r'', include('apps.manage.apps.contacts.urls')),
]
