# coding=utf8

import traceback
from django.core.mail import EmailMessage
from django.conf import settings
from core.utils import log as logger


def send(subject, content, recipient_list):
    try:
        if recipient_list:
            msg = EmailMessage(subject, content, settings.EMAIL_HOST_USER, recipient_list)
            msg.send()
    except Exception as e:
        trace = traceback.format_exc()
        logger.error(trace)
