# coding=utf8
from django.db.models.query_utils import Q
from django_filters import FilterSet


class BaseFilterSet(FilterSet):
    def filter_search(self, queryset, name, value):
        search_fields = getattr(self.Meta, 'search_fields', None)
        if search_fields:
            search_filter = Q()
            for search_field in search_fields:
                search_field = search_field.replace('.', '__')
                search_filter |= Q(**{search_field + "__contains": value})
            return queryset.filter(search_filter)
        return queryset


class UIStyle(object):
    datebox = {'class': 'easyui-datebox', 'data-options': "editable:false", 'style': 'height: 32px;'}
    datemonthbox = {'class': 'easyui-datebox', 'data-options': "editable:false", 'style': 'height: 32px;'}
    input = {'class': 'input-brand'}