# coding=utf8
from __future__ import unicode_literals

from django import template
from django.db.models.query_utils import Q

from apps.manage.rules import Rules

register = template.Library()


@register.inclusion_tag('manage/tags/menus.html', takes_context=True)
def auth_menus(context):
    """""
    # 系统菜单
    """
    user = context.request.user
    if user.is_superuser:
        menus = Rules
    else:
        if not getattr(user, 'manager', None):
            menus = None
        else:
            menus = user.manager.get_menus()
    return {'menus': menus}


@register.inclusion_tag('manage/tags/values.html', takes_context=True)
def render_values(context, values):
    """""
    # 数据统计模块
    """
    return {'values': values}


@register.inclusion_tag('manage/tags/actions.html', takes_context=True)
def render_actions(context, actions):
    """""
    # 页面操作按钮
    """
    return {'actions': actions}