const stream = 'wss://api.zb.com:9999/websocket';
// const stream = "wss://kline.zb.com:2443/websocket";
const WebSocket = require('ws');
const request = require('request');
const crypto = require('ezcrypto').Crypto;
const options = {};
const observerSymbol = ["btcusdt", 'ethusdt', 'ethbtc', "eosbtc", "eosusdt", 'bccusdt', "bccbtc"];
const redis = require('redis');
const redisClient = redis.createClient();
const publishKey = "ZB@2";
const accountInfoChannel = "getaccountinfo";
const APIKEY = "171985b3-3e8a-47af-aa7c-865f3db1909f";
const APISECRET = "30577876-ddd0-4969-92f9-f6a1dfb85703";
const lastEventTimeMap = {};


function signParams2Str(params) {
  // const accountReq = {accesskey: APIKEY,channel: accountInfoChannel,event: "addChannel", sign: "a5f785d4627ae21f4b4baf9c1baf1a60"};
  let paramsSort = sortDict(params);
  const paramsSortString = JSON.stringify(paramsSort);
  let digest = crypto.SHA1(APISECRET);
  let sign = crypto.HMAC(crypto.MD5, paramsSortString, digest);
  paramsSort['sign'] = sign;
  return JSON.stringify(paramsSort);
}


function sortDict(dict) {
  let dict2 = {},
    keys = Object.keys(dict).sort();
  for (let key of keys) {
    dict2[key] = dict[key]
  }
  return dict2
}


const _handleSocketError = function(error) {
  // Errors ultimately result in a `close` event.
  // see: https://github.com/websockets/ws/blob/828194044bf247af852b31c49e2800d557fedeff/lib/websocket.js#L126
  console.log('WebSocket error: '+this.endpoint+
    (error.code ? ' ('+error.code+')' : '')+
    (error.message ? ' '+error.message : '')
  );
};

const _handleSocketOpen = function(opened_callback) {
  console.log("open");
  for (const symbol of observerSymbol) {
    const req = {event: 'addChannel', channel: symbol + '_depth'};
    console.log(JSON.stringify(req));
    this.send(JSON.stringify(req));
  }
  const accountReq = {
    accesskey: APIKEY,
    channel: accountInfoChannel,
    event: "addChannel",
  };
  const accountReqStr = signParams2Str(accountReq);
  setInterval(() => {
    this.send(accountReqStr);
  }, 1500);
};

const _handleSocketClose = function(code, reason) {
  console.log(code);
  console.log(reason);
  console.log('close');
  subscribe();
};

const _subscribe = function(callback, opened_callback = false) {
  const ws = new WebSocket(stream);
  ws.reconnect = options.reconnect;
  ws.isAlive = false;
  ws.on('open', _handleSocketOpen.bind(ws, opened_callback));
  // ws.on('pong', _handleSocketHeartbeat);
  ws.on('error', _handleSocketError);
  ws.on('close', _handleSocketClose.bind(ws));
  ws.on('message', function(data) {
    try {
      callback(JSON.parse(data));
    } catch (error) {
      console.log('Parse error: '+error.message);
    }
  });
  return ws;
};

function subscribe() {
  _subscribe((data) => {
    if (data.channel === accountInfoChannel) {
      try {
        const coins = data.data.coins;
        const balances = {};
        for (const coin of coins) {
          balances[coin.enName] = {"onOrder": coin.freez, "available": coin.available};
        }
        redisClient.hset("balance", "zb", JSON.stringify(balances));
      } catch (e) {
        redisClient.hset("balance", "zb", JSON.stringify({}));
        console.error(data);
      }
    } else {
      const depth = data;
      const key = depth.channel.replace('_', '').toUpperCase() + '@zb';
      const symbol = depth.channel.replace('_depth', '').toUpperCase();
      const lastEventTime = lastEventTimeMap[symbol] || 0;
      if (depth.timestamp > lastEventTime) {
        lastEventTimeMap[symbol] = depth.timestamp;
        console.log(symbol + '@' + depth.timestamp * 1000 + ' from websocket');
        const publishContent = JSON.stringify({symbol, time: depth.timestamp * 1000});
        const depthJson = JSON.stringify({asks: depth.asks.reverse(), bids: depth.bids, symbol});
        redisClient.set(key, depthJson, 'EX', 2);
        redisClient.publish(publishKey, publishContent);
      }
    }
  });
}

function _request(method, url, callback) {
  let opt = {
    url,
    method,
    headers: {
      Connection: "Keep-Alive"
    }
  };
  request(opt, (error, response, body) => {
    if ( !callback ) return;

    if ( error )
      return callback( error, {} );

    if ( response && response.statusCode !== 200 )
      return callback( response, {} );

    return callback( null, JSON.parse(body) );
  });
}

function depthByRest(symbol,callback) {
  const url = `http://api.zb.com/data/v1/depth?market=${symbol}&size=10`;
  _request("GET", url, (err, data) => {
    if (err) {
      console.error(url + "出错");
    } else {
      const key = symbol.replace('_', '').toUpperCase() + 'DEPTH@zb';
      symbol = symbol.toUpperCase();
      const lastEventTime = lastEventTimeMap[symbol] || 0;
      if (data.timestamp > lastEventTime) {
        lastEventTimeMap[symbol] = data.timestamp;
        console.log(symbol + '@' + data.timestamp * 1000 + ' from rest');
        const publishContent = JSON.stringify({symbol, time: data.timestamp * 1000});
        const depthJson = JSON.stringify({asks: data.asks.reverse(), bids: data.bids, symbol});
        redisClient.set(key, depthJson, 'EX', 2);
        redisClient.publish(publishKey, publishContent);
      }
    }
    if (callback) {
      callback(err, data);
    }
  });
}

function getBalanceByRest() {
  const params = {
    accesskey: APIKEY,
    method: "getAccountInfo"
  };
  const sign = JSON.parse(signParams2Str(params)).sign;
  const url = `https://trade.zb.com/api/getAccountInfo?accesskey=${APIKEY}&method=getAccountInfo&sign=${sign}&reqTime=${Date.now()}`
  _request("GET", url, (err, data) => {
    if (err) {
      console.error(err);
      console.error(url);
    } else {
      console.debug(data);
    }
  });
}

function run() {
  subscribe();
  setInterval(() => {
    for (const symbol of observerSymbol) {
      depthByRest(symbol);
    }
  }, 500);
  setInterval(() => {
    getBalanceByRest();
  }, 6000);
}

run();

module.exports = {
  depthByRest,
  subscribe
};
