const os = require('os');


function getLocalIpv4s() {
  var ifaces = os.networkInterfaces();
  var ips = [];
  var func = function(details) {
    if (details.family === 'IPv6' || details.internal) {
      return;
    }
    ips.push(details.address);
  };
  for (var dev in ifaces) {
    ifaces[dev].forEach(func);
  }
  return ips;
};

const ips = getLocalIpv4s();

exports.allIps = ips;