const stream = 'wss://api.zb.com:9999/websocket';
const WebSocket = require('ws');
const options = {};
const observerSymbol = ["btcusdt"];
const redis = require('redis');
const redisClient = redis.createClient();
const publishKey = "ZB@2";

const _handleSocketError = function(error) {
  // Errors ultimately result in a `close` event.
  // see: https://github.com/websockets/ws/blob/828194044bf247af852b31c49e2800d557fedeff/lib/websocket.js#L126
  console.log('WebSocket error: '+this.endpoint+
    (error.code ? ' ('+error.code+')' : '')+
    (error.message ? ' '+error.message : '')
  );
};

const _handleSocketOpen = function(opened_callback) {
  this.isAlive = true;
  console.log("open");
  for (const symbol of observerSymbol) {
    const req = {event: 'addChannel', channel: symbol + '_depth'};
    this.send(JSON.stringify(req));
  }
};

const _handleSocketClose = function(code, reason) {
  console.log(code);
  console.log(reason);
  console.log('close');
  subscribe();
};

const _subscribe = function(callback, opened_callback = false) {
  const ws = new WebSocket(stream);
  ws.reconnect = options.reconnect;
  ws.isAlive = false;
  ws.on('open', _handleSocketOpen.bind(ws, opened_callback));
  // ws.on('pong', _handleSocketHeartbeat);
  ws.on('error', _handleSocketError);
  ws.on('close', _handleSocketClose.bind(ws));
  ws.on('message', function(data) {
    try {
      callback(JSON.parse(data));
    } catch (error) {
      console.log('Parse error: '+error.message);
    }
  });
  return ws;
};

function subscribe() {
  _subscribe((depth) => {
    console.log(depth.timestamp * 1000);
    const key = depth.channel.replace('_', '').toUpperCase() + '@zb';
    const symbol = depth.channel.replace('_depth', '').toUpperCase();
    const publishContent = JSON.stringify({symbol, time: depth.timestamp * 1000})
    const depthJson = JSON.stringify({asks: depth.asks.reverse(), bids: depth.bids, symbol})
    redisClient.set(key, depthJson);
    redisClient.publish(publishKey, publishContent);
  })
}

subscribe();
