const stream = 'wss://api.zb.com:9999/websocket';
// const stream = "wss://kline.zb.cn/websocket";
const WebSocket = require('ws');
const request = require('request');
const pako = require('pako');
const crypto = require('ezcrypto').Crypto;
const ips = require("./util").allIps;
const options = {};
const observerSymbol = ["btcusdt", 'ethusdt', 'ethbtc', "eosbtc", "eosusdt"];
// const observerSymbol = ["btcusdt", 'bccusdt', "bccbtc"];
const redis = require('redis');
const redisClient = redis.createClient();
const publishKey = "ZB@2";
const accountInfoChannel = "getaccountinfo";
const APIKEY = "6b07db0c-dc4f-4a90-9955-665041bdbdbf";
const APISECRET = "7ac9bcc3-5f0c-4eaf-99c9-80cb6a45165a";
const lastEventTimeMap = {};
const lastLastEventTimeMap = {};
const lastDataMap = {};
const lastLastDataMap = {};
let balanceByRestOk = true;
let balanceByWebsocketOk = true;
let currentIpIndex = 0;


function selectIp() {
  currentIpIndex = (currentIpIndex + 1) % ips.length;
  return ips[currentIpIndex];
}

function signParams2Str(params) {
  // const accountReq = {accesskey: APIKEY,channel: accountInfoChannel,event: "addChannel", sign: "a5f785d4627ae21f4b4baf9c1baf1a60"};
  let paramsSort = sortDict(params);
  const paramsSortString = JSON.stringify(paramsSort);
  let digest = crypto.SHA1(APISECRET);
  let sign = crypto.HMAC(crypto.MD5, paramsSortString, digest);
  paramsSort['sign'] = sign;
  return JSON.stringify(paramsSort);
}

function signParamsStr(paramStr) {
  const digest = crypto.SHA1(APISECRET);
  const sign = crypto.HMAC(crypto.MD5, paramStr, digest);
  return sign;
}


function sortDict(dict) {
  let dict2 = {},
    keys = Object.keys(dict).sort();
  for (let key of keys) {
    dict2[key] = dict[key]
  }
  return dict2
}


const _handleSocketError = function(error) {
  // Errors ultimately result in a `close` event.
  // see: https://github.com/websockets/ws/blob/828194044bf247af852b31c49e2800d557fedeff/lib/websocket.js#L126
  console.log('WebSocket error: '+this.endpoint+
    (error.code ? ' ('+error.code+')' : '')+
    (error.message ? ' '+error.message : '')
  );
};

const _handleSocketOpen = function(opened_callback) {
  console.log("open");
  for (const symbol of observerSymbol) {
    const req = {event: 'addChannel', channel: symbol + '_depth'};
    console.log(JSON.stringify(req));
    this.send(JSON.stringify(req));
  }
  const accountReq = {
    accesskey: APIKEY,
    channel: accountInfoChannel,
    event: "addChannel",
  };
  const accountReqStr = signParams2Str(accountReq);
  setInterval(() => {
    this.send(accountReqStr);
  }, 1500);
};

const _handleSocketClose = function(code, reason) {
  console.log(code);
  console.log(reason);
  console.log('close');
  subscribe();
};

const _subscribe = function(callback, opened_callback = false) {
  const ws = new WebSocket(stream);
  ws.reconnect = options.reconnect;
  ws.isAlive = false;
  ws.on('open', _handleSocketOpen.bind(ws, opened_callback));
  // ws.on('pong', _handleSocketHeartbeat);
  ws.on('error', _handleSocketError);
  ws.on('close', _handleSocketClose.bind(ws));
  ws.on('message', function(data) {
    try {
      callback(JSON.parse(data));
    } catch (error) {
      console.log('Parse error: '+error.message);
    }
  });
  return ws;
};

function subscribe() {
  _subscribe((data) => {
    if (data.channel === accountInfoChannel) {
      try {
        const coins = data.data.coins;
        const balances = {};
        for (const coin of coins) {
          balances[coin.enName] = {"onOrder": coin.freez, "available": coin.available};
        }
        redisClient.hset("balance", "zb", JSON.stringify(balances));
        balanceByWebsocketOk = true;
      } catch (e) {
        balanceByWebsocketOk = false;
        if (!balanceByRestOk) {
          redisClient.hset("balance", "zb", JSON.stringify({}));
        }
        console.error(data);
      }
    } else {
      const depth = data;
      const symbol = depth.channel.replace('_depth', '').toUpperCase();
      _handleDepthData(symbol, data, "websocket");
    }
  });
}

function _request(method, url, callback) {
  const ip = selectIp();
  let opt = {
    url,
    method,
    headers: {
      Connection: "Keep-Alive"
    },
    forever: true,
  };
  if (ip) {
    opt.localAddress = ip;
  }
  request(opt, (error, response, body) => {
    if ( !callback ) return;

    if ( error )
      return callback( error, {} );

    if ( response && response.statusCode !== 200 )
      return callback( response, {} );

    return callback( null, JSON.parse(body) );
  });
}

function _handleDepthData(symbol, data, source) {
  const key = symbol.replace('_', '').toUpperCase() + 'DEPTH@zb';
  symbol = symbol.toUpperCase();
  const lastEventTime = lastEventTimeMap[symbol] || 0;
  const lastLastEventTime = lastLastEventTimeMap[symbol] || 0;
  const asks = data.asks.reverse().slice(0, 5);
  const bids = data.bids.slice(0, 5);
  const currentJsonData = JSON.stringify({asks, bids});
  if (data.timestamp > lastEventTime
    || (data.timestamp === lastEventTime && currentJsonData !== lastDataMap[symbol] && (currentJsonData !== lastLastDataMap[symbol] || lastLastEventTime != data.timestamp))) {
    if (symbol === "BTCUSDT") {
      let consoleMethod = console.log;
      if (data.timestamp === lastEventTime) {
        consoleMethod = console.warn;
      }
      consoleMethod(symbol + '@' + data.timestamp * 1000 + ' from ' + source);
      consoleMethod(currentJsonData);
    }
    lastLastEventTimeMap[symbol] = lastEventTimeMap[symbol];
    lastEventTimeMap[symbol] = data.timestamp;
    lastLastDataMap[symbol] = lastDataMap[symbol];
    lastDataMap[symbol] = currentJsonData;
    const publishContent = JSON.stringify({symbol, time: data.timestamp * 1000});

    const depthJson = JSON.stringify({asks, bids, symbol});
    if (asks[0][0] >= bids[0][0]) {
      redisClient.set(key, depthJson, 'EX', 2);
      redisClient.publish(publishKey, publishContent);
    } else {
      console.error("买一大于卖一，数据有误")
    }
  }
}

const lastDepthRestSendTimeMap = {};
let detphRestSentAmount = 0;

function depthByRest(symbol,callback) {
  // const urls = [`http://api.zb.cn/data/v1/depth?market=${symbol}&size=5`, `http://api.zb.com/data/v1/depth?market=${symbol}&size=5`];
  // detphRestSentAmount += 1;
  // const index = detphRestSentAmount % 2;
  const url = `http://api.zb.com/data/v1/depth?market=${symbol}&size=5`;
  const sendTime = Date.now();
  _request("GET", url, (err, data) => {
    const lastDepthRestSendTime = lastDepthRestSendTimeMap[symbol] || 0;
    if (sendTime > lastDepthRestSendTime) {
      lastDepthRestSendTimeMap[symbol] = sendTime
    } else {
      console.error("延迟太大，丢弃该数据");
      return;
    }
    if (err) {
      console.error(url + "出错");
    } else {
      _handleDepthData(symbol, data, "rest");
    }
    if (callback) {
      callback(err, data);
    }
  });
}

function getBalanceByRest() {
  const sign = signParamsStr(`accesskey=${APIKEY}&method=getAccountInfo`);
  const url = `https://trade.zb.com/api/getAccountInfo?accesskey=${APIKEY}&method=getAccountInfo&sign=${sign}&reqTime=${Date.now()}`;
  _request("GET", url, (err, data) => {
    if (err) {
      console.error(err);
      balanceByRestOk = false;
      if (!balanceByWebsocketOk) {
        redisClient.hset("balance", "zb", JSON.stringify({}));
      }
    } else {
      try {
        const coins = data.result.coins;
        const balances = {};
        for (const coin of coins) {
          balances[coin.enName] = {"onOrder": coin.freez, "available": coin.available};
        }
        redisClient.hset("balance", "zb", JSON.stringify(balances));
        balanceByRestOk = true;
      } catch (e) {
        balanceByRestOk = false;
        if (!balanceByWebsocketOk) {
          redisClient.hset("balance", "zb", JSON.stringify({}));
        }
        console.error(data);
      }
    }
  });
}

function run() {
  subscribe();
  const depthInterval = Math.max(60 * 1000 / (900 * ips.length / observerSymbol.length), 60);
  console.log(depthInterval);
  setInterval(() => {
    for (const symbol of observerSymbol) {
      depthByRest(symbol);
    }
  }, depthInterval);
  setInterval(() => {
    getBalanceByRest();
  }, 2000);
}

run();

module.exports = {
  depthByRest,
  subscribe
};
