const stream = 'wss://api.zb.com:9999/websocket';
const WebSocket = require('ws');
const crypto = require('crypto');
const options = {};
const observerSymbol = ["btcusdt", 'ethusdt', 'ltcusdt', 'bccusdt',];
const redis = require('redis');
const redisClient = redis.createClient();
const publishKey = "ZB@2";
const accountInfoChannel = "getaccountinfo";
const APIKEY = "c2e5bd19-6ac3-489e-8e3a-b6e40b4d5b6d";
const APISECRET = "15f974c4-fc64-462e-a815-cd0469156300";

const _handleSocketError = function(error) {
  // Errors ultimately result in a `close` event.
  // see: https://github.com/websockets/ws/blob/828194044bf247af852b31c49e2800d557fedeff/lib/websocket.js#L126
  console.log('WebSocket error: '+this.endpoint+
    (error.code ? ' ('+error.code+')' : '')+
    (error.message ? ' '+error.message : '')
  );
};

const _handleSocketOpen = function(opened_callback) {
  this.isAlive = true;
  console.log("open");
  for (const symbol of observerSymbol) {
    const req = {event: 'addChannel', channel: symbol + '_depth'};
    this.send(JSON.stringify(req));
  }
  const accountReq = {accesskey: APIKEY,channel: accountInfoChannel,event: "addChannel", sign: "a5f785d4627ae21f4b4baf9c1baf1a60"};
  console.log(JSON.stringify(accountReq));
  this.send(JSON.stringify(accountReq));
};

const _handleSocketClose = function(code, reason) {
  console.log(code);
  console.log(reason);
  console.log('close');
  subscribe();
};

const _subscribe = function(callback, opened_callback = false) {
  const ws = new WebSocket(stream);
  ws.reconnect = options.reconnect;
  ws.isAlive = false;
  ws.on('open', _handleSocketOpen.bind(ws, opened_callback));
  // ws.on('pong', _handleSocketHeartbeat);
  ws.on('error', _handleSocketError);
  ws.on('close', _handleSocketClose.bind(ws));
  ws.on('message', function(data) {
    try {
      callback(JSON.parse(data));
    } catch (error) {
      console.log('Parse error: '+error.message);
    }
  });
  return ws;
};

function subscribe() {
  _subscribe((data) => {
    if (data.channel === accountInfoChannel) {
      console.log(data);
      const coins = data.data.coins;
      const balances = {};
      for (const coin of coins) {
        balances[coin.enName] = {"onOrder": coin.freez, "available": coin.available};
      }
      console.log(JSON.stringify(balances));
      redisClient.hset("balance", "zb", JSON.stringify(balances));
    } else {
      const depth = data;
      const key = depth.channel.replace('_', '').toUpperCase() + '@zb';
      const symbol = depth.channel.replace('_depth', '').toUpperCase();
      console.log(symbol + '@' + depth.timestamp * 1000 + ' latency=' + (Date.now() - depth.timestamp * 1000) + 'ms');
      const publishContent = JSON.stringify({symbol, time: depth.timestamp * 1000})
      const depthJson = JSON.stringify({asks: depth.asks.reverse(), bids: depth.bids, symbol})
      redisClient.set(key, depthJson, 'EX', 1);
      redisClient.publish(publishKey, publishContent);
    }
  });
}

subscribe();
